/*
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: _C_EXIT.C $
   $Locker:  $	$Name:  $	$State: Exp $

	void _c_exit(void)

	Perform the light-weight cleanup. This will perform only the absolutly
	necessary steps to ensure a proper program termination.

	The functions _cexit() and _c_exit() perform distinct tasks!
	To contiune the program execution upon exit of _c_exit() is
	strongly discouraged!

	Input:
		<none>

	Return:

	Note:
		The main reason for this function is to detach the program
		from internally hooked interrupts.

	Conforms to:
		<none>

	See also:
		_cexit, _exit, exit

	Target compilers:
		Any C compiler

	Origin:
		1997/10/10 Steffen Kaiser (ska)

	Revised by:
		<none>

	File Revision:    Revision 1.1  1997/10/13 07:09:10  ska
*/

#include <_clib.h>			/* standard include, must be the first! */
#include <process.h>

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: _C_EXIT.C 1.1 1997/10/13 07:09:10 ska Exp $";
#endif

_CLibFunc void _c_exit(void)
{	/* Currently nothing is needed here; this function is simply a
		placeholder */
}
