/*
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: STRNCPY.C $
   $Locker:  $	$Name:  $	$State: Exp $

	char_t *strncpy(char_t *dst, char_t *src, size_t length)

	Copy NUL terminated string from src to dst But not more than
	length bytes. The terminator byte is always appended.
	dst must be at least length bytes.

	Input:
		dst != NULL
		src != NULL
		length != 0

	Return:
		dst

	Note:
		length is treated unsigned

	Conforms to:
		ANSI C

	See also:
		strncpy, strcat, stpcpy, memcpy, memmove

	Target compilers:
		Any C compiler

	Origin:
		1997/10/10 Steffen Kaiser (ska)

	Revised by:
		<none>

	File Revision:    Revision 1.2  1998/02/08 04:55:59  ska
*/

#include <_clib.h>			/* standard include, must be the first! */
#include <_defs.h>
#include <_string.h>

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: STRNCPY.C 1.2 1998/02/08 04:55:59 ska Exp $";
#endif

_CLibFunc char_t ___PTR *strncpy(char_t ___PTR * const dst
 , REG char_t const ___PTR * src, REG size_t length)
{	REG char_t ___PTR *p;

	assert(dst != NULL);
	assert(src != NULL);
	assert(length != 0);

	p = dst;
	while((*p++ = *src++) != NUL && --length);
	p[-1] = NUL;	/* will work in both cases: length == 0 &&
						NUL byte copied */

	return dst;
}
