/*
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: STRLEN.C $
   $Locker:  $	$Name:  $	$State: Exp $

	size_t strlen(char_t *str)

	Return the length of the string.

	Input:
		str != NULL

	Return:
		length of str

	Note:
		<none>

	Conforms to:
		ANSI C

	See also:
		strchr

	Target compilers:
		Any C compiler

	Origin:
		1997/10/10 Steffen Kaiser (ska)

	Revised by:
		<none>

	File Revision:    Revision 1.2  1998/02/08 04:55:59  ska
*/

#include <_clib.h>			/* standard include, must be the first! */
#include <_string.h>

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: STRLEN.C 1.2 1998/02/08 04:55:59 ska Exp $";
#endif

_CLibFunc size_t strlen(char_t const ___PTR * s)
{	assert(s != NULL);

	return _strstop(s) - s;
}
