/*
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: MEMLWR.C $
   $Locker:  $	$Name:  $	$State: Exp $

	void *memlwr(void *s, size_t length)

	Lowercase the memory area.

	Input:
		s != NULL

	Return:
		s

	Note:
		<none>

	Conforms to:
		<none>

	See also:
		strlwr, memupr

	Target compilers:
		Any C compiler

	Origin:
		1997/10/10 Steffen Kaiser (ska)

	Revised by:
		<none>

	File Revision:    Revision 1.2  1998/02/08 04:55:59  ska
*/

#include <_clib.h>			/* standard include, must be the first! */
#include <ctype.h>
#include <_string.h>

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: MEMLWR.C 1.2 1998/02/08 04:55:59 ska Exp $";
#endif

_CLibFunc void ___PTR *memlwr(void ___PTR * const s, size_t length)
{	REG char_t ___PTR *p;

	assert(s != NULL);

	if(length) {
		p = s;
		do *p = tolower(*p);
		while(--length);
	}

	return s;
}
