/* $Id: _FFBLK.INC 1.2 1998/01/29 07:10:10 ska Exp $
   $Locker:  $	$Name:  $	$State: Exp $

	Declaration of struct ffblk
	To be included & modified by dirent.h & dir.h

   $Log: _FFBLK.INC $
   Revision 1.2  1998/01/29 07:10:10  ska
   add: limits.h: probed-values support
   chg: moved _ABORT_STD_EXITCODE from process.h -> _config.h
   chg: stdio.h: (char)->(void) for fread() & fwrite() acc. ISO9899
   add: stdio.h: inserted "const" acc. ISO9899
   fix: assert.h: _assert2() macro in NDEBUG branch misses the 2nd argument
   add: _wchar_t.h to define type (wchar_t)
   chg: renamed defs.h -> stddef.h
   chg: checked for ANSI C compatibly: errno.h, float.h, stddef.h, assert.h,
   	limits.h

   Revision 1.1  1997/10/27 12:27:31  ska
   Initial revision

*/

#ifndef ___FFBLK_INC
#define ___FFBLK_INC

#include <_config.h>

#define _NOLFN ((word)(-1))			/* status of a non-LFN ffblk */
struct ffblk
{
    byte	ff_reserved[0x15];
    byte	ff_attrib;
    word	ff_ftime;
    word	ff_fdate;
    dword	ff_fsize;
    char	ff_name[13];
#ifdef LFN_WIN95
/* the LFN support is totally virtuell as long as the ffblk structure
	will be used */
	struct {
		dword ff_attr;
		qword ff_tcreation;		/* creation time */
		qword ff_taccess;		/* last access time */
		qword ff_tmodification;	/* modification time */
		dword ff_hisize;		/* size := (hisize << 32) | lowsize */
		dword ff_lowsize;
		byte ff_dummy[8];
		char ff_longname[260];
		char ff_shortname[14];
		word ff_status;
	} ff_lfn;
#endif
};

#endif
