/*
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: LMALLOC.C $
   $Locker:  $	$Name:  $	$State: Exp $

	void *malloc(size_t size)

	Allocates an object of size bytes in the local heap.
	If size == 0, an unique pointer is returned, but it may not
	necessary point to a legal memory area.

	If DEBUG_HEAP was defined at compile time, allocated memory is
	filled with dbgHeapAllocCh.

	Input:
		<none>

	Return:
		NULL: not enough free memory
		else: pointer to the allocated memory

	Note:
		Local heap only

	Conforms to:
		ANSI

	See also:
		free, realloc, calloc, _fmalloc

	Target compilers:
		Any C compiler

	Origin:
		1997/10/10 Steffen Kaiser (ska)

	Revised by:
		<none>

	File Revision:    Revision 1.3  1998/01/29 07:10:05  ska
*/

#include <_clib.h>			/* standard include, must be the first! */
#include <_alloc.h>

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: LMALLOC.C 1.3 1998/01/29 07:10:05 ska Exp $";
#endif

_CLibFunc void ___PTR *
malloc(const size_t size)
{	
	assert(_heap != NULL);		/* security check if heap is initialized */

	return realloc(NULL, size);
}
