/*
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: LCALLOC.C $
   $Locker: ska $	$Name:  $	$State: Exp $

	void *calloc(size_t num, size_t size)

	Allocate an array of num items with a size of size bytes each.
	The allocated memory is cleared with NULs.

	The real allocation is performed through malloc().

	Note: It is not required that the allocated amount is truely
	num * size, it may be larger.

	Input:
		(num * size) < SIZE_T_MAX (no check performed!)

	Return:
		NULL: if no memory could be allocated
		else: pointer to the first item of the allocated array

	Note:
		Local heap only

	Conforms to:
		ANSI

	See also:
		malloc, free, _fcalloc

	Target compilers:
		Any C compiler

	Origin:
		1997/10/10 Steffen Kaiser (ska)

	Revised by:
		<none>

	File Revision:    Revision 1.5  1998/02/11 07:40:34  ska
*/

#include <_clib.h>			/* standard include, must be the first! */
#include <_alloc.h>
#include <string.h>

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: LCALLOC.C 1.5 1998/02/11 07:40:34 ska Exp ska $";
#endif

_CLibFunc void ___PTR *
calloc(const size_t num
      ,const size_t size)
{	REG void ___PTR *p;
	REG size_t length;

#if _IN_ALLOC == 0 || _IN_ALLOC == 1	/* local or far interface */
			/* A chunk cannmot exceed 64KB */
	assert((long)num * size < 0x10000l);
#else	/* _IN_ALLOC == 2 */
	_assert2(num * size < num || num * size < size
	 , "num * size < 0x100000000");
#endif	/* _IN_ALLOC == 0 || _IN_ALLOC == 1 */

	if((p = realloc(NULL, length = num * size)) != NULL)
		/* clear space */
		memset(p, 0, length);

	return p;
}
