/*
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: _IO_INIT.C $
   $Locker:  $	$Name:  $	$State: Exp $

	void __io_init(void)

	Initializes the STDIO package and can be called more than once.
	Performed actions:
		1) Set stdout to line buffer mode of connected to a TTY
		2) Set stdprn to binary mode if incoporated
		3) Register fcloseall into at_exit chain

	Input:
		<none>

	Return:
		<none>

	Note:
		Should be called from the compiler's startup chain. As long as
		there is no portable way to so, __io_init() will be called
		from core functions of the STDIO package.

	Conforms to:
		<none>

	See also:

	Target compilers:
		Any C compiler

	Origin:
		1997/11/03 Robert de Bath (see CONTRIB\STDIO2.ZIP)

	Revised by:
		1997/11/23 Steffen Kaiser (ska)

	File Revision:    Revision 1.1  1997/11/26 04:03:45  ska
*/

#include <_clib.h>			/* standard include, must be the first! */
#include <io.h>				/* setmode(), isatty() */
#include <fcntl.h>			/* O_BINARY */
#include <_process.h>		/* __atexitFcts[] & index */
#include "stdio.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: _IO_INIT.C 1.1 1997/11/26 04:03:45 ska Exp $";
#endif

_CLibFunc void 
__io_init(void)
{	static int first_time = 1;

	if( !first_time ) return ;
	first_time = 0;

	if (isatty(1)) {
#if _IOFBF		/* Possibly someone likes to change _IOFBF == 0 */
		stdout->mode &= ~__MODE_BUF;
#endif	/* _IOFBF */
		stdout->mode |= _IOLBF;
	}


#ifdef FIO_PRN
	setmode(FIO_PRN, O_BINARY);		/* stdprn defaults to text, but this
							would lead to nonsense - 1997/11/14 ska*/
#endif	/* FIO_PRN */

   __atexitFcts[ATEXIT_FIO] = (atexit_t)fcloseall;	/* we do not use atexit()
   			because this would place the close all function at a random
   			place, probably invoked before an user atexit() function.
   			This would cause confusion.

   			This hack should be removed and changed into a normal
   			atexit() call as soon as the __io_init() function has been
   			placed into the compiler's startup chain.  - 1997/11/14 ska*/
}
