/*
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $Id: STDIO.H 1.2 1997/11/26 04:03:45 ska Exp $
   $Locker:  $	$Name:  $	$State: Exp $

	Module declarations & macros of the STDIO package

*/

#ifndef __LOCAL_STDIO_H
#define __LOCAL_STDIO_H

#include <stdio.h>			/* source in "official" declarations */

extern FILE *__IO_list;		/* For fflushall() & fcloseall() */

#define Inline_init __io_init()		/* "startup" initializator
			as long we don't control the compiler's internal startup
			chain, we incorporate it into CLib functions.
			Comment out this line to indicate that __io_init() is
			called by the startup chain while the initialization phase
			automatically. */


#ifdef Inline_init		/* init STDIO package from core functions */
#define Inline_call Inline_init;
_CLibFunc void __io_init(void);

#else	/* Inline_init */
#define Inline_call

#endif	/* Inline_init */

#endif
