/* $Id: _STDARG.INC 1.3 1998/02/11 07:40:00 ska Exp ska $
   $Locker: ska $	$Name:  $	$State: Exp $

	Compiler-depended implementation of the ANSI conform STDARG
	package.
 	This package makes _no_ use of the '...'

	The current implementation assumes this useage:
		<type> <fct>(<arguments>, <last argument>, ...)
		{	va_list <ap>;

			va_start(<ap>, <last argument>);
					......		// use of <ap> via: va_arg(<ap>, <type>)
			va_end(<ap>);
					......		// no use of <ap>
		}

	Multiple va_list's can be initialized & used.
	Currently there is _no_ check if <ap> is used after va_end()!

	Furthermore this package assumes this internal stack orientation and
	results of operations:
		stack:
			X+??								<2nd variable argument>
			X+sizeof(last argument)		...		<1st variable argument>
			X							last argument
		&<last argument> == X
		(byte*)&<last argument> + sizeof(<last argument>) == (byte*)&...

	Target compilers:
		Borland C++ v5

   $Log: _STDARG.INC $
   Revision 1.3  1998/02/11 07:40:00  ska
   Auto Check-in

   Revision 1.2  1998/01/29 07:09:32  ska
   add: _stdarg.h: probed-values support (_local.h)

   Revision 1.1  1997/11/18 04:24:39  ska
   Auto Check-in

*/

#ifndef ___STDARG_H
#define ___STDARG_H

#include <_local.inc>			/* source-in probed values */

/* Check if the compiler meets the restrictions. If no probed values
	are available assume that all is correct */
#ifdef _STDARG_LEFT_TO_RIGHT
#error	"Your compiler pushes the arguments from left to right. This is not supported, yet!"
#endif
#ifdef _STDARG_NO_PROMOTE_CHAR
#error "Your compiler does not promote (char) to (int). This is not supported, yet!"
#endif 

/*
 *	We will check and correct types with sizeof(type) < sizeof(int), but
 *	(float) cannot be determined. This correction should not take any
 *	additional resources within the compiled program as it can be
 *	completely determined at compile-time.
 */
#define __va_size(type) ((sizeof(type) < sizeof(int))? sizeof(int): sizeof(type))

/*
 *	va_start() initializes the variable argument counter
 */
#define va_start(ap,lastfix)	\
	((ap) = ((va_list)&(lastfix)) + __va_size(lastfix))

/*
 *	va_end() terminates the counter
 */
#define va_end(ap)		((ap) = 0)

/*
 *	va_arg() returns the next argument
 *
 *	Internally va_arg() advances to the next variable argument, then
 *	steps back to the currently requested one. This is necessary, because
 *	(va_list) is to be assumed as a scalar type, thus, the size of this
 *	argument cannot be preserved within the (va_list) argument to be
 *	evaluated at the next va_arg().
 */
#define va_arg(ap,type)	\
	(*((type *)(((ap) += __va_size(type)) - __va_size(type))))

#endif
