COMMENT ^
   $Id: _DEF.INC 1.1 1997/10/27 12:27:09 ska Exp $
   $Locker:  $	$Name:  $	$State: Exp $

	This is just a start file for testing purpose!

	Standard include file for assembly sources.

	Provided are four segments:
		class	| name	|	useage
		--------+-------+---------------------
		CODE	| _TEXT	|	the code segment
		DATA	| _DATA	|	initialized data
		BSS		| _BSS	| 	uninitialized data
		STACK	| _STACK|	stack segment

	To encapsule the use of pseudo instructions two macros are
	provided for each of the segments:
		<class>_Seg@	to open the segement <class>, and
		<class>_End@	to close this segment
	 <class> lowercase except 1st character

	Six macros encapsule the near/far problematic of pointers:
		NDATA, FDATA, HDATA; NCODE, FCODE, HCODE
	If Nxxx is true: neither FARxxx nor Hxxx is defined.
	If Fxxx is true: Nxxx is not, but Hxxx may be defined.
	If Hxxx is true: Nxxx is not, but Fxxx is defined.
	Nxxx means that this type of pointer consists of the offset only
	relatively to DGROUP (DS:) if DATA, or _TEXT (CS:) if CODE.
	Fxxx means that this type of pointer consists of both the
	segment and offset.
	Hxxx is equal to FARxxx except that _resulting_ offsets have to
	be normalized. (Perhaps incoming offsets, too?)

	DGROUP is the segment selector for the local data segment.
	In tiny mode _CODE is part of DGROUP.

   $Log: _DEF.INC $
   Revision 1.1  1997/10/27 12:27:09  ska
   Initial revision

^

;;
;;	First: Pointer related settings
;;

FOUND = 0

NCODE = 0
NDATA = 0
FCODE = 0
FDATA = 0
HCODE = 0
HDATA = 0

IFDEF __TINY__
	NDATA = 1
	NCODE = 1
	FOUND = 1 + FOUND
ENDIF		;; __TINY__

IFDEF __SMALL__
	NDATA = 1
	NCODE = 1
	FOUND = 1 + FOUND
ENDIF		;; __SMALL__

IFDEF __MEDIUM__
	NDATA = 1
	FCODE = 1
	FOUND = 1 + FOUND
ENDIF		;; __MEDIUM__

IFDEF __COMPACT__
	FDATA = 1
	NCODE = 1
	FOUND = 1 + FOUND
ENDIF		;; __COMPACT__

IFDEF __LARGE__
	FDATA = 1
	FCODE = 1
	FOUND = 1 + FOUND
ENDIF		;; __LARGE__

IFDEF __HUGE__
	FDATA = 1
	FCODE = 1
	HDATA = 1
	HCODE = 1
	FOUND = 1 + FOUND
ENDIF		;; __HUGE__

IF FOUND NE 1
	%OUT No or more than one memory model specified!
	.ERR No or more than one memory model specified!
ENDIF		;; FOUND NE 1

;;
;;	Some standard macros
;;

pushIm	MACRO	value		; Push immediate CLOBBERS AX!!!
	mov ax, value
	push ax
ENDM		;; pushIm

;;
;;	Setup standard alignments and references and macros
;;

IF FDATA
	DPTR		EQU DWORD PTR
PushPtrSym@	MACRO symbol			; note: clobbers AX!
							;; Push pointer to symbol
	pushIm <SEG symbol>
	pushIm <OFFSET symbol>
ENDM		;; PushPtrSym@
DefSym@		MACRO symbol, value			; Define data pointer
	IFB <value>
		symbol DD ?
	ELSE		;; blank <value>
		symbol DD value
	ENDIF		;; blank <value>
ENDM		;; DefSym@
DefRefSym@	MACRO symbol1, symbol2		; Define reference to symbol
	symbol1 dw OFFSET symbol2, SEG symbol2
ENDM		;; DefRefSym@

ELSE			;; FDATA

	DPTR		EQU WORD PTR
PushPtrSym@	MACRO symbol			; note: clobbers AX!
							;; Push pointer to symbol
	pushIm <OFFSET DGROUP:symbol>
ENDM		;; PushPtrSym@
DefSym@		MACRO symbol, value		; Define data pointer
	IFB <value>
		symbol DW ?
	ELSE		;; blank <value>
		symbol DW value
	ENDIF		;; blank <value>
ENDM		;; DefSym@
DefRefSym@	MACRO symbol1, symbol2	; Define reference to symbol
	symbol1 dw OFFSET DGROUP:symbol2
ENDM		;; DefRefSym@
ENDIF		;; FDATA

IF FCODE
	CPTR		EQU DWORD PTR
ExtFunc@	MACRO symbol		; Extern reference to function
	EXTRN	symbol:FAR
ENDM		;; ExtFunc@
DefFunc@	MACRO symbol		; Define function
	PUBLIC symbol
	symbol	PROC FAR
ENDM		;; DefFunc@

ELSE	;; FCODE

	CPTR		EQU WORD PTR
ExtFunc@	MACRO symbol		; Extern reference to function
	EXTRN	symbol:NEAR
ENDM		;; ExtFunc@
DefFunc@	MACRO symbol		; Define function
	PUBLIC symbol
	symbol	PROC NEAR
ENDM		;; DefFunc@
ENDIF	;; FCODE


;;
;;	Define the open/close segment macros
;;

Code_Seg@	MACRO			; Open code segment
_TEXT	SEGMENT BYTE PUBLIC 'CODE'
	ASSUME	CS:_TEXT
ENDM		;; Code_Seg@

Code_End@	MACRO			; Close code segment
_TEXT	ENDS
ENDM		;; Code_End@


Data_Seg@	MACRO			; Open data segment
_DATA	SEGMENT BYTE PUBLIC 'DATA'
ENDM		;; Data_Seg@

Data_End@	MACRO			; Close data segment
_DATA	ENDS
ENDM		;; Data_End@


Bss_Seg@	MACRO				; Open BSS segment
_BSS	SEGMENT BYTE PUBLIC 'BSS'
ENDM		;; Bss_Seg@

Bss_End@	MACRO				; Close BSS segment
_BSS	ENDS
ENDM		;; Bss_End@


;;
;;	Group the data segments
;;

IFDEF __TINY__
DGROUP	GROUP	_TEXT, _TEXT_END_, _DATA, _BSS, _BSS_END_
CGROUP	EQU DGROUP

ELSE		; __TINY__
DGROUP	GROUP	_DATA, _BSS, _BSS_END_
CGROUP	GROUP	_TEXT, _TEXT_END_

ENDIF		; __TINY__

;;
;;	Now declare the order of the segments
;;

Code_Seg@
Code_End@
_TEXT_END_ SEGMENT BYTE PUBLIC 'CODE'
_TEXT_END_ ENDS
Data_Seg@
Data_End@
Bss_Seg@
Bss_End@
_BSS_END_ SEGMENT BYTE PUBLIC 'BSS'
_BSS_END_ ENDS


;;
;;	Some definition shared with C components!
;;
STACK_MARGAIN	EQU 200h		;; minimum stack & security region heap<>stack
HEAP_END		EQU 0			;; end-of-heap marker
