COMMENT `
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
`
COMMENT `
   $Id: C0.ASM 1.2 1998/02/11 07:40:00 ska Exp ska $
   $Locker: ska $	$Name:  $	$State: Exp $

	This is just a start file for testing purpose!

	File Revision:    Revision 1.2  1998/02/11 07:40:00  ska
`

;; Source in the standard definitions
INCLUDE _def.inc

;; We need to know the end of the BSS segment and, by this, the end
;; of all the data segments

_BSS_END_	SEGMENT	BYTE PUBLIC 'BSS'
	?bss_end	label byte
_BSS_END_	ENDS

_TEXT_END_	SEGMENT BYTE PUBLIC 'CODE'
	?code_end	label byte
_TEXT_END_	ENDS


;; We need to know the start of the BSS segment to erase all of it
Bss_Seg@
	?bss_seg	label byte
Bss_End@

Data_Seg@			;; define some initially used variables
	EXTRN __stklen:WORD		; minimal length of the stack & local heap
	EXTRN __lheap:WORD		; start of the local heap (relative to SS: !)

;;	FOR TESTING: MINIMUM ARGV[] ARRAY!
	nullString	db 0
	DefRefSym@	argv0, nullString
	DefSym@		argv1, 0


	PUBLIC __psp
	__psp	dw 0			; current PSP
	?noMem	db 'Data segment too large', 0
Data_End@


Code_Seg@
	ASSUME	DS:_DATA

;; those references we need later
ExtFunc@	_main
ExtFunc@	_exit
ExtFunc@	__hmemset
ExtFunc@	__abort

IFDEF __TINY__
	ORG 100h
ENDIF		;; __TINY__

start:
;;
;;	First setup the segment registers
;;	CS: Code segment
;;	DS: _DATA segment
;;	ES: current PSP
;;
IFDEF __TINY__
	mov ax, cs
	mov ds, ax
	mov es, ax
	mov __psp, ax
ELSE		;; __TINY__
	mov ax, DGROUP
	mov ds, ax
	mov ah, 62h			;; Get current PSP
	int 21h
	mov es, bx
	mov __psp, bx
ENDIF		;; __TINY__

;;
;;	Setup the memory/stack
;;	1) Resize the current memory block
;;	2) Relocate the stack
;;	3) Initialize the BSS
;;

COMMENT `
	How does the memory looks like?
	n: length of _TEXT segment
	m: length of _DATA segment
	l: length of _BSS segment
	k: length of _STACK segment
	h: length of local heap
	rows: left: relative start address
		middle: length
		right: segment
	a) tiny memory model
		00000h	0FFh				PSP
		00100h	n					_TEXT
		+n		m					_DATA
		+m+n	l					_BSS
		+l+m+n	0					_BSS_END_
		+l+m+n	10000h-l-m-n		_STACK		(no real segment)
	
	b) small & compact
		00000h	0FFh			PSP
		00000h	n				_TEXT
		00000h	m				_DATA
		+m		l				_BSS
		+m+l	0				_BSS_END_
		+m+l	10000h-m-l		_STACK		(no real segment)
	
	c) far & huge & medium
		00000h		0FFh	PSP
		00000h		n		_TEXT
		00000h		m		_DATA
		+m			l		_BSS
		+m+l		0		_BSS_END_
		10000h-k-h	h		<local heap> part of _STACK
		10000h-k	k		_STACK
`

;
; Calculate the requested size of the memory block
;

; If NDATA, test if the DGROUP fits into 64KB
IF NDATA
	; If NDATA: BSS is always part of DGROUP
	; -> seg ?bss_end == seg DGROUP
	; --> Offset DGROUP:?bss_end is the length of DGROUP!
	mov ax, OFFSET DGROUP:?bss_end	; used bytes of DGROUP
	neg ax					; free bytes in DGROUP
	; AX cannot be 0, because we define at least one variable within
	; DGROUP: _heap!
	cmp ax, STACK_MARGAIN	; smaller than the smallest possible?
	jc ?memTerminate		; memory overflow!
	cmp ax, __stklen		; smaller than the requested stack size?
	jc ?memTerminate		; memory overflow!
ELSE	;; NDATA
	mov ax, __stklen
	cmp ax, STACK_MARGAIN	; make sure the stack size has the minimum size
	jnc ?stkLenOK			; no -> adjust
	mov ax, STACK_MARGAIN
?stkLenOK:
ENDIF	;; NDATA
	and al, 0feh			; make sure the stack is word oriented
	mov __stklen, ax

; ?bss_end	is always the last requested address, behind the stack
;	is placed (at runtime)
; The only exception is tiny, because this memory model _always_ has a
; block size of 64KB.
IFDEF __TINY__
	mov bx, 1000h			; 64KB block
ELSE		;; __TINY__
	; calculate a real mode 20bit length of the requested block
	; ES:0 is the start; ?bss_end is the end of the block
	; __stklen additionally bytes are to be taken into account
	mov bx, SEG ?bss_end		; 1st: calculate segment difference
	mov ax, es
	sub bx, ax					; no check, because it would mean that
								; the system is corrupt if < 0!
	mov ax, OFFSET ?bss_end
	test al, 0fh				; completely filled paragraphe?
	jz ?calcLengthPar			; yes
	inc bx						; we need one paragraphe more
?calcLengthPar:
	mov cl, 4
	shr ax, cl					; bytes -> paragraphes
	add bx, ax					; complete length of program
	; no check; think what would mean if an overflow would occure here!?

	; now take the stack segment into account
	mov ax, __stklen
	test al, 0fh
	jz ?calcLengthStk
	inc bx
?calcLengthStk:
	shr ax, cl					; CL still 4
	add bx, ax					; complete length of program memory block
								; not exactly exact but 15 bytes more stack
								; won't waste too much, yes?
	; no check. If an overflow would occure, we would need a basic
	; program size of >960KB & a requested stack size of 64KB; very
	; unlikely
ENDIF		;; __TINY__

; Resize the memory block
	mov ah, 4Ah					; DOS API Resize Memory Block
	; BX := requested length
	; ES == (still) PSP
	INT 21h
	jc ?memTerminate			; hey, that would mean that we never had
								; a block large enough


;
;	Install the stack
;
IFNDEF __TINY__
IF NDATA
	; DS == SS
	mov ax, ds
	mov ss, ax
ELSE		;; NDATA
	; We install the stack segment (64KB) at:
	; SS := ES + BX - 64KB in order that SP := 0 is correct in all
	; circumstances
	mov ax, es
	add ax, bx					; segment address of first byte behind prg
	sub ax, 1000h				; new start of stack
	mov ss, ax
ENDIF		;; NDATA
ENDIF		;; !__TINY__
	mov sp, 0

;
;	Now initialize the BSS segment
;
	push ds				; make sure _hmemcpy() does not alter DS
IF FDATA
	; BSS may be >= 64KB
	; length := (seg_end - seg_seg) * 16 + (ofs_end - ofs_seg) [20 bits]
	mov ax, SEG ?bss_end
	sub ax, SEG ?bss_seg
	mov bx, ax
	mov ch, ah
	mov cl, 4
	shr ch, cl				; CH := hi 4 bits of length
	shl bx, cl				; BX := (delta seg) * 16
	mov ax, OFFSET ?bss_end
	sub ax, OFFSET ?bss_seg
	jnc ?bssInit1
	dec ch
?bssInit1:
	add ax, bx
	jnc ?bssInit2
	inc ch
?bssInit2:
	mov cl, ch
	mov ch, 0
	push cx					; HIWORD of length
	push ax					; LOWORD of length
ELSE 			;; FDATA
	xor ax, ax
	push ax					; HIWORD of length
	mov ax, OFFSET _BSS:?bss_end
	sub ax, OFFSET _BSS:?bss_seg
	push ax					; LOWORD of length
ENDIF		;; FDATA

	xor ax, ax
	push ax					; character to fill the BSS segment
	mov ax, SEG ?bss_seg
	push ax
	mov ax, OFFSET ?bss_seg
	push ax
	call __hmemset			; initialize the BSS segment
	add sp, 5 * 2
	pop ds

;
;	Initialize the local heap
;
; If DS == SS -> _heap := OFFSET DGROUP:?bss_end (segment: DS & SS)
; If DS != SS -> _heap := -__stklen (segment: SS only)
IF NDATA		 ; DS == SS
	mov bx, OFFSET DGROUP:?bss_end
	mov __lheap, bx
	mov BYTE PTR [bx], HEAP_END	; mark end of heap
ELSE		;; NDATA
	mov bx, __stklen		; __stklen != 0 always
	neg bx
	mov __lheap, bx
	mov BYTE PTR SS:[bx], HEAP_END	; mark end of heap
ENDIF		;; NDATA


;
;	Now call main() with a minimum of arguments
;
	PushPtrSym@	argv0		; Push **argv
	pushIm		1			; Push argc
	call _main				; there is no need to POP here
	push ax					; the return value is the exit code for exit()
	call _exit				; will never return, but is C function so
							; we need to keep the stack frame correct!

?memTerminate:				; "Out of memory"
	PushPtrSym@	?noMem
	jmp __abort

Code_End@


	END start
