//
//
// A short and hopefully easy to understand demonstration of CauseWay DLL
// usage with Watcom.
//
//

// Need function definitions
#include "dllfunc.h"

// Name the module
char ModuleName[]={"DEXDLL"};

// main module value to be seen by the DLL
int MainToDLLInt = 12345;
char *MainToDLLCharStar="String in main module, visible by DLL";

//
// The actual do something code.
//
int main()
{
unsigned char *DLL;
void _cdecl (*DLLFunction)(char *);

	// Try and load the module.
	DLL=LoadModule(ModuleName);
	if (DLL) {

		printf("Module ");
		printf(ModuleName);
		printf(" loaded successfully\n");

		// Fetch the test function address
		DLLFunction=GetProcAddress(DLL,"_SAYHELLO");

		if (DLLFunction) {
			// Give the test function a shout
			DLLFunction("Hello World!\n");

		} else {
			printf("Failed to GetProcAddress\n");

		}
			// Lose the module again
			FreeModule(DLL);

			printf("Module ");
			printf(ModuleName);
			printf(" discarded\n");

	} else {
		printf("Failed to load ");
		printf(ModuleName);
		printf(" module...\n");
	}
	return(0);
}

void __export CalledByDLL (char * message)
{
	printf("I've been called by the DLL to say...\n");
	printf(message);
}
