/* common preprocessor defines, 2.14.4 */

/* For an example, see https://www.boost.org/doc/libs/1_60_0/boost/config/compiler/gcc.hpp */

#ifndef prepdefs_h
#define prepdefs_h

#include <limits.h>

#if (defined (__SVR4) && defined (__sun))
#  define __SOLARIS
#endif

#if defined(__x86_64__) || defined(_M_X64) || defined(i386) || defined(__i386__) || defined(__X86__) || defined(__i386) || defined(_M_IX86)
#  define __INTEL
#endif

#if defined(__ARM_ARCH_2__) || defined(__ARM_ARCH_3__)  || defined(__ARM_ARCH_3M__)  || defined(__ARM_ARCH_4T__) || defined(__TARGET_ARM_4T) \
|| defined(__ARM_ARCH_5_)   || defined(__ARM_ARCH_5E_)  || defined(__ARM_ARCH_6__)   || defined(__ARM_ARCH_6J__) || defined(__ARM_ARCH_6K__) \
|| defined(__ARM_ARCH_6T2_) || defined(__ARM_ARCH_6Z__) || defined(__ARM_ARCH_6ZK__) || defined(__ARM_ARCH_7__)  || defined(__ARM_ARCH_7A__) \
|| defined(__ARM_ARCH_7R__) || defined(__ARM_ARCH_7M__) || defined(__ARM_ARCH_7S__)  || defined(__aarch64__)     || defined(_M_ARM64) \
|| defined(__ARM)
#define __ARMCPU
#endif

#if defined(__powerpc) || defined(__powerpc__) || defined(__powerpc64__) || defined(__POWERPC__) || defined(__ppc__) || defined(__PPC__) || defined(_ARCH_PPC)
#define __PPCCPU
#endif

#if (defined(__INTEL) && \
  defined(__GNUC__) && (!(defined(OPENSUSE) || defined(__linux__) || defined(__SOLARIS) || defined(LUA_DOS) || defined(__OS2__) || defined(__APPLE__))))
#define CPUINFO
#endif

#if (defined(__GNUC__) && !(defined(OPENSUSE) || defined(LUA_RASPI_STRETCH) || defined(__OS2__) || defined(__APPLE__) || defined(__powerpc__)))
#define CPUID
#endif

/* 32 or 64 bit ?  2.25.5 */
#if LONG_MAX == 2147483647L
#  define IS32BIT
#elif LONG_MAX == 9223372036854775807L
#  define IS64BIT
#else
#  error long int is not a 32bit or 64bit type
#endif

/* DJGPP is around 10 % faster with string operations if IS32BITALIGNED has been set.
   Included Mac OS X in 2.37.0 to avoid SEGBUS 10 errors due to unaligned data. */
#if (defined(__GNUC__) && defined(IS32BIT))
#  define IS32BITALIGNED
#endif

/* inline ... */

#if defined __GNUC__ && !defined __GNUC_STDC_INLINE__ && !defined __GNUC_GNU_INLINE__
#define __GNUC_GNU_INLINE__ 1
#endif

#ifndef NOINLINE
#define INLINE inline
#else
#define INLINE
#endif

#if defined(__GNUC__)
#define FORCE_INLINE __attribute__((always_inline)) inline
#else
#define FORCE_INLINE inline
#endif

#endif
