#ifndef long_h
#define long_h

#include "lstate.h"
#include "sunpro.h"


#define longdouble long double
#ifndef __ARMCPU
#define DLong ieee_long_double_shape_type
#else
#define DLong ieee_double_shape_type
#endif


#define checkdlong(L, n) (DLong *)luaL_checkudata(L, n, "longdouble")

#define getdlongvalue(L,idx) (((DLong *)lua_touserdata(L, (idx)))->value)

#define checkandgetdlong(L,idx) (((DLong *)luaL_checkudata(L, (idx), "longdouble"))->value)

#define checkandgetdlongnum(L,idx) ({ \
  longdouble __x = (agn_isnumber(L, (idx))) ? agn_tonumber(L, (idx)) : (checkandgetdlong(L, (idx))); \
  (__x); \
})


#define agnL_checkdlongnum(L,idx,procname) ({ \
  longdouble __x; \
  if (agn_isnumber(L, (idx))) { \
    __x = agn_tonumber(L, (idx)); \
  } else if (agnL_isdlong(L, (idx))) { \
    __x = getdlongvalue(L, (idx)); \
  } else { \
    __x = 0.0L; \
    luaL_error(L, "Error in " LUA_QS ": number or longdouble expected, got %s.", procname, luaL_typename(L, idx)); \
  } \
  (__x); \
})


#ifndef __ARMCPU

#define tolong(L,idx,ds)  (lua_isnumber(L, (idx)) ? ds.d : ds.f)

#define checkandgetdlongint(L,idx) ({ \
  longdouble __x = (agn_isnumber(L, (idx))) ? agn_tonumber(L, (idx)) : (checkandgetdlong(L, (idx))); \
  (sun_intl(__x)); \
})

#ifndef PROPCMPLX
#define getdlongnum(L,d,idx,procname) { \
  if (agn_isnumber(L, (idx))) { \
    lua_Number x = agn_tonumber(L, (idx)); \
    d.f = AGN_NAN; \
    d.z = x + 0*I; \
    d.d = x; \
  } else if (lua_iscomplex(L, (idx))) { \
    d.f = AGN_NAN; \
    d.d = AGN_NAN; \
    d.z = agn_tocomplex(L, (idx)); \
  } else if (agnL_isdlong(L, (idx))) { \
    d.d = AGN_NAN; \
    d.z = AGN_NAN; \
    d.f = getdlongvalue(L, (idx)); \
  } else { \
    luaL_error(L, "Error in " LUA_QS ": (complex) number or longdouble expected, got %s.", procname, luaL_typename(L, idx)); \
  } \
}

#else

#define tolong(L,idx,ds)  (lua_isnumber(L, (idx)) ? ds.d : ds.f)

#define checkandgetdlongint(L,idx) ({ \
  longdouble __x = (agn_isnumber(L, (idx))) ? agn_tonumber(L, (idx)) : (checkandgetdlong(L, (idx))); \
  (sun_intl(__x)); \
})

#define getdlongnum(L,d,idx,procname) { \
  if (agn_isnumber(L, (idx))) { \
    lua_Number x = agn_tonumber(L, (idx)); \
    d.f = AGN_NAN; \
    d.z[0] = x; \
    d.z[1] = 0; \
    d.d = x; \
  } else if (agn_iscomplex(L, (idx))) { \
    int rc; \
    lua_Number z[2]; \
    agn_tocomplexx(L, idx, &rc, z); \
    d.f = AGN_NAN; \
    d.d = AGN_NAN; \
    d.z[0] = z[0]; \
    d.z[1] = z[1]; \
  } else { \
    d.f = AGN_NAN; \
    d.d = AGN_NAN; \
    d.z[0] = AGN_NAN; \
    d.z[1] = AGN_NAN; \
    luaL_error(L, "Error in " LUA_QS ": (complex) number expected, got %s.", procname, luaL_typename(L, idx)); \
  } \
}
#endif  /* of PROPCMPLX */

#else  /* now ARM part */

#define tolong(L,idx,ds)  (lua_isnumber(L, (idx)) ? ds.d : ds.f)

#define checkandgetdlongint(L,idx) ({ \
  longdouble __x = (agn_isnumber(L, (idx))) ? agn_tonumber(L, (idx)) : (checkandgetdlong(L, (idx))); \
  (sun_intl(__x)); \
})

#ifndef PROPCMPLX
#define getdlongnum(L,d,idx,procname) { \
  if (agn_isnumber(L, (idx))) { \
    lua_Number x = agn_tonumber(L, (idx)); \
    d.z = x + 0*I; \
    d.d = x; \
  } else if (agn_iscomplex(L, (idx))) { \
    d.d = AGN_NAN; \
    d.z = agn_tocomplex(L, (idx)); \
  } else { \
    d.d = AGN_NAN; \
    d.z = AGN_NAN; \
    luaL_error(L, "Error in " LUA_QS ": (complex) number expected, got %s.", procname, luaL_typename(L, idx)); \
  } \
}
#else
#define getdlongnum(L,d,idx,procname) { \
  if (agn_isnumber(L, (idx))) { \
    lua_Number x = agn_tonumber(L, (idx)); \
    d.z[0] = x; \
    d.z[1] = 0; \
    d.d = x; \
  } else if (agn_iscomplex(L, (idx))) { \
    int rc; \
    lua_Number z[2]; \
    agn_tocomplexx(L, idx, &rc, z); \
    d.d = AGN_NAN; \
    d.z[0] = z[0]; \
    d.z[1] = z[1]; \
  } else { \
    d.d = AGN_NAN; \
    d.z[0] = AGN_NAN; \
    d.z[1] = AGN_NAN; \
    luaL_error(L, "Error in " LUA_QS ": (complex) number expected, got %s.", procname, luaL_typename(L, idx)); \
}
#endif  /* of PROPCMPLX */

#endif  /* of __ARMCPU */

#ifndef __ARMCPU
#define createdlong(L,x) { \
  DLong *__d = (DLong *)lua_newuserdata(L, sizeof(DLong)); \
  lua_setmetatabletoobject(L, -1, "longdouble", 1); \
  __d->value = (x); \
}
#else
#define createdlong(L,x) { \
  DLong *__d = (DLong *)lua_newuserdata(L, sizeof(DLong)); \
  __d->value = (x); \
}
#endif

/* Constant taken from: https://stackoverflow.com/questions/34924598/why-cant-i-add-ldbl-epsilon-to-1 */
#ifndef __ARMCPU
#define AGN_LDBL_EPSILON 1.084202172485504434E-19
#else
#define AGN_LDBL_EPSILON DBL_EPSILON
#endif

#endif
