/*
** $Id: gdilib.c,v 0.1 21.11.2009 $
** Binding to the g2 graphic library, version 0.72
** g2 was written by Ljubomir Milanovi & Horst Wagner, http://g2.sourceforge.net.
** This binding was written by Alexander Walz, primarily on a Sun Blade 1500.
** See Copyright Notice in agena.h
*/

#include <stdio.h>
#include <stdlib.h>  /* malloc, free */
#include <math.h>  /* for HUGE_VAL */
#include <string.h>  /* for strstr, strlen */

#include "agena.h"
#include "agnxlib.h"
#include "agenalib.h"

#define gdilib_c
#define LUA_LIB

#include <g2.h>
#include <g2_gd.h>
#include <g2_PS.h>
#include <g2_FIG.h>

#if defined(__unix__) || defined(__APPLE__)
#include <g2_X11.h>
#elif defined(__WIN32)
#include <g2_win32.h>
#endif

#if !(defined(__OS2__) || defined(LUA_ANSI))
#define AGENA_GDILIBNAME "gdi"
LUALIB_API int (luaopen_gdi) (lua_State *L);
#endif


static int gdi_point (lua_State *L) {
  int d, nargs;
  lua_Number a1, b1;
  nargs = lua_gettop(L);
  d = agn_checknumber(L, 1);
  a1 = agn_checknumber(L, 2);
  b1 = agn_checknumber(L, 3);
  if (nargs == 4)
    g2_pen(d, agn_checknumber(L, 4));
  g2_plot(d, a1, b1);
  return 0;
}


static int gdi_line (lua_State *L) {
  int d, nargs;
  lua_Number a1, b1, a2, b2;
  nargs = lua_gettop(L);
  if (nargs < 5)
    luaL_error(L, "to " LUA_QS ", at least five numbers needed.", "gdi.line");
  d = agn_checknumber(L, 1);
  a1 = agn_checknumber(L, 2);
  b1 = agn_checknumber(L, 3);
  a2 = agn_checknumber(L, 4);
  b2 = agn_checknumber(L, 5);
  if (nargs == 6)
    g2_pen(d, agn_checknumber(L, 6));
  g2_line(d, a1, b1, a2, b2);
  return 0;
}


static int gdi_rectangle (lua_State *L) {
  int d, nargs;
  lua_Number a1, b1, a2, b2;
  nargs = lua_gettop(L);
  if (nargs < 5)
    luaL_error(L, "to " LUA_QS ", at least five numbers needed.", "gdi.rectangle");
  d = agn_checknumber(L, 1);
  a1 = agn_checknumber(L, 2);
  b1 = agn_checknumber(L, 3);
  a2 = agn_checknumber(L, 4);
  b2 = agn_checknumber(L, 5);
  if (nargs == 6)
    g2_pen(d, agn_checknumber(L, 6));
  g2_rectangle(d, a1, b1, a2, b2);
  return 0;
}


static int gdi_rectanglefilled (lua_State *L) {
  int d, nargs;
  lua_Number a1, b1, a2, b2;
  nargs = lua_gettop(L);
  if (nargs < 5)
    luaL_error(L, "to " LUA_QS ", at least five numbers needed.", "gdi.rectanglefilled");
  d = agn_checknumber(L, 1);
  a1 = agn_checknumber(L, 2);
  b1 = agn_checknumber(L, 3);
  a2 = agn_checknumber(L, 4);
  b2 = agn_checknumber(L, 5);
  if (nargs == 6)
    g2_pen(d, agn_checknumber(L, 6));
  g2_filled_rectangle(d, a1, b1, a2, b2);
  return 0;
}


static int gdi_triangle (lua_State *L) {
  int d, nargs;
  lua_Number a1, b1, a2, b2, a3, b3;
  nargs = lua_gettop(L);
  if (nargs < 7)
    luaL_error(L, "to " LUA_QS ", at least seven numbers needed.", "gdi.triangle");
  d = agn_checknumber(L, 1);
  a1 = agn_checknumber(L, 2);
  b1 = agn_checknumber(L, 3);
  a2 = agn_checknumber(L, 4);
  b2 = agn_checknumber(L, 5);
  a3 = agn_checknumber(L, 6);
  b3 = agn_checknumber(L, 7);
  if (nargs == 8)
    g2_pen(d, agn_checknumber(L, 8));
  g2_triangle(d, a1, b1, a2, b2, a3, b3);
  return 0;
}


static int gdi_trianglefilled (lua_State *L) {
  int d, nargs;
  lua_Number a1, b1, a2, b2, a3, b3;
  nargs = lua_gettop(L);
  if (nargs < 7)
    luaL_error(L, "to " LUA_QS ", at least seven numbers needed.", "gdi.trianglefilled");
  d = agn_checknumber(L, 1);
  a1 = agn_checknumber(L, 2);
  b1 = agn_checknumber(L, 3);
  a2 = agn_checknumber(L, 4);
  b2 = agn_checknumber(L, 5);
  a3 = agn_checknumber(L, 6);
  b3 = agn_checknumber(L, 7);
  if (nargs == 8)
    g2_pen(d, agn_checknumber(L, 8));
  g2_filled_triangle(d, a1, b1, a2, b2, a3, b3);
  return 0;
}


static int gdi_arc (lua_State *L) {
  int d, nargs;
  lua_Number x, y, r1, r2, a1, a2;
  nargs = lua_gettop(L);
  if (nargs < 7)
    luaL_error(L, "to " LUA_QS ", at least seven numbers needed.", "gdi.arc");
  d = agn_checknumber(L, 1);
  x = agn_checknumber(L, 2);
  y = agn_checknumber(L, 3);
  r1 = agn_checknumber(L, 4);
  r2 = agn_checknumber(L, 5);
  a1 = agn_checknumber(L, 6);
  a2 = agn_checknumber(L, 7);
  if (nargs == 8)
    g2_pen(d, agn_checknumber(L, 8));
  g2_arc(d, x, y, r1, r2, a1, a2);
  return 0;
}


static int gdi_arcfilled (lua_State *L) {
  int d, nargs;
  lua_Number x, y, r1, r2, a1, a2;
  nargs = lua_gettop(L);
  if (nargs < 7)
    luaL_error(L, "to " LUA_QS ", at least seven numbers needed.", "gdi.arcfilled");
  d = agn_checknumber(L, 1);
  x = agn_checknumber(L, 2);
  y = agn_checknumber(L, 3);
  r1 = agn_checknumber(L, 4);
  r2 = agn_checknumber(L, 5);
  a1 = agn_checknumber(L, 6);
  a2 = agn_checknumber(L, 7);
  if (nargs == 8)
    g2_pen(d, agn_checknumber(L, 8));
  g2_filled_arc(d, x, y, r1, r2, a1, a2);
  return 0;
}


static int gdi_circle (lua_State *L) {
  int d, nargs;
  lua_Number a1, b1, r;
  nargs = lua_gettop(L);
  if (nargs < 4)
    luaL_error(L, "to " LUA_QS ", at least four numbers needed.", "gdi.circle");
  d = agn_checknumber(L, 1);
  a1 = agn_checknumber(L, 2);
  b1 = agn_checknumber(L, 3);
  r =  agn_checknumber(L, 4);
  if (nargs == 5)
    g2_pen(d, agn_checknumber(L, 5));
  g2_circle(d, a1, b1, r);
  return 0;
}


static int gdi_circlefilled (lua_State *L) {
  int d, nargs;
  lua_Number a1, b1, r;
  nargs = lua_gettop(L);
  if (nargs < 4)
    luaL_error(L, "to " LUA_QS ", at least four numbers needed.", "gdi.circlefilled");
  d = agn_checknumber(L, 1);
  a1 = agn_checknumber(L, 2);
  b1 = agn_checknumber(L, 3);
  r =  agn_checknumber(L, 4);
  if (nargs == 5)
    g2_pen(d, agn_checknumber(L, 5));
  g2_filled_circle(d, a1, b1, r);
  return 0;
}


static int gdi_ellipse (lua_State *L) {
  int d, nargs;
  lua_Number a1, b1, r1, r2;
  nargs = lua_gettop(L);
  if (nargs < 5)
    luaL_error(L, "to " LUA_QS ", at least five numbers needed.", "gdi.ellipse");
  d = agn_checknumber(L, 1);
  a1 = agn_checknumber(L, 2);
  b1 = agn_checknumber(L, 3);
  r1 =  agn_checknumber(L, 4);
  r2 =  agn_checknumber(L, 5);
  if (nargs == 6)
    g2_pen(d, agn_checknumber(L, 6));
  g2_ellipse(d, a1, b1, r1, r2);
  return 0;
}


static int gdi_ellipsefilled (lua_State *L) {
  int d, nargs;
  lua_Number a1, b1, r1, r2;
  nargs = lua_gettop(L);
  if (nargs < 5)
    luaL_error(L, "to " LUA_QS ", at least five numbers needed.", "gdi.ellipsefilled");
  d = agn_checknumber(L, 1);
  a1 = agn_checknumber(L, 2);
  b1 = agn_checknumber(L, 3);
  r1 =  agn_checknumber(L, 4);
  r2 =  agn_checknumber(L, 5);
  if (nargs == 6)
    g2_pen(d, agn_checknumber(L, 6));
  g2_filled_ellipse(d, a1, b1, r1, r2);
  return 0;
}


static int gdi_text (lua_State *L) {
  int d, nargs;
  lua_Number a1, b1;
  const char *str;
  nargs = lua_gettop(L);
  if (nargs < 4)
    luaL_error(L, "to " LUA_QS ", at least four arguments needed.", "gdi.text");
  d = agn_checknumber(L, 1);
  a1 = agn_checknumber(L, 2);
  b1 = agn_checknumber(L, 3);
  str = luaL_checkstring(L, 4);
  if (nargs == 5)
    g2_pen(d, agn_checknumber(L, 5));
  g2_string(d, a1, b1, str);
  return 0;
}


/* admin functions */

static int gdi_open (lua_State *L) {
  int width, height, d;
  const char *filename, *fn;
  d = 0;  /* to avoid compiler warnings */
  if (lua_gettop(L) < 2)
    luaL_error(L, "to " LUA_QS ", at least two numbers needed.", "gdi.open");
  width = agn_checknumber(L, 1);
  height = agn_checknumber(L, 2);
  filename = luaL_optstring(L, 3, "nofilenamegiven");
  if (width < 1)
    luaL_error(L, "to " LUA_QS ", width must be positive.", "gdi.open");
  if (height < 1)
    luaL_error(L, "to " LUA_QS ", height must be positive.", "gdi.open");
  if (lua_gettop(L) < 3 || strcmp(filename, "nofilenamegiven") == 0)
#if defined(__unix__) || defined(__APPLE__)
    d = g2_open_X11(width, height);
#elif defined(_WIN32)
    d = g2_open_win32(width, height, "agena >> plot", 0);
#else
    d = NULL;
#endif
  else {
    fn = strstr(filename, ".ps");
    if (fn != NULL && tools_strlen(fn) == 3)  /* 2.25.1 tweak */
      d = g2_open_PS(filename, g2_A4, g2_PS_port);
    else
      luaL_error(L, "to " LUA_QS ", unknown file type.", "gdi.open");
    fn = strstr(filename, ".fig");
    if (fn != NULL && tools_strlen(fn) == 4) {  /* 2.25.1 tweak */
      d = g2_open_FIG(filename);
      goto l100;
    }
#ifndef __OS2__
    fn = strstr(filename, ".gif");
    if (fn != NULL && tools_strlen(fn) == 4) {  /* 2.25.1 tweak */
      d = g2_open_gd(filename, width, height, g2_gd_gif);
      goto l100;
    }
    fn = strstr(filename, ".png");
    if (fn != NULL && tools_strlen(fn) == 4) {  /* 2.25.1 tweak */
      d = g2_open_gd(filename, width, height, g2_gd_png);
      goto l100;
    }
    fn = strstr(filename, ".jpg");
    if (fn != NULL && tools_strlen(fn) == 4) {  /* 2.25.1 tweak */
      d = g2_open_gd(filename, width, height, g2_gd_jpeg);
      goto l100;
    }
#endif
  }
l100:
  lua_pushnumber(L, d);  /* push descriptor */
  return 1;
}


static int gdi_close (lua_State *L) {
  g2_close(agn_checknumber(L, 1));
  return 0;
}


static int gdi_flush (lua_State *L) {
  g2_flush(agn_checknumber(L, 1));
  return 0;
}


static int gdi_lastaccessed (lua_State *L) {
  lua_pushnumber(L, g2_ld());
  return 1;
}


static int gdi_reset (lua_State *L) {
  g2_clear(agn_checknumber(L, 1));
  return 0;
}


static int gdi_fontsize (lua_State *L) {
  int d;
  lua_Number s;
  if (lua_gettop(L) != 2)
    luaL_error(L, "to " LUA_QS ", two numbers needed.", "gdi.fontsize");
  d = agn_checknumber(L, 1);
  s = agn_checknumber(L, 2);
  g2_set_font_size(d, s);
  return 0;
}


static int gdi_thickness (lua_State *L) {
  int d;
  lua_Number s;
  if (lua_gettop(L) != 2)
    luaL_error(L, "to " LUA_QS ", two numbers needed.", "gdi.thickness");
  d = agn_checknumber(L, 1);
  s = agn_checknumber(L, 2);
  g2_set_line_width(d, s);
  return 0;
}


static int gdi_dash (lua_State *L) {
  int d;
  size_t i, nops;
  lua_Number dashlen, *len;
  if (lua_gettop(L) != 2)
    luaL_error(L, "to " LUA_QS ", two arguments expected.", "gdi.dash");
  d = agn_checknumber(L, 1);
  luaL_argcheck(L, lua_type(L, 2) == LUA_TSEQ, 2, "sequence expected");
  nops = agn_seqsize(L, 2);
  if (nops > 0) {
    len = malloc(sizeof(lua_Number)*nops);
    for (i=0; i < nops; i++) {
      dashlen = lua_seqrawgetinumber(L, 2, i + 1);
      if (dashlen == HUGE_VAL) {
        xfree(len);
        luaL_error(L, "to " LUA_QS ", dash component is not a number.", "gdi.dash");
      }
      len[i] = (dashlen < 1) ? 1 : dashlen;
    }
    g2_set_dash(d, nops, len);
    xfree(len);
  } else {  /* reset to solid line */
    g2_set_dash(d, 0, NULL);
  }
  return 0;
}


/* colours */

static int gdi_ink (lua_State *L) {
  int d;
  lua_Number r, g, b;
  if (lua_gettop(L) != 4)
    luaL_error(L, "to " LUA_QS ", four arguments needed.", "gdi.ink");
  d = agn_checknumber(L, 1);
  r = agn_checknumber(L, 2);
  g = agn_checknumber(L, 3);
  b = agn_checknumber(L, 4);
  lua_pushnumber(L, g2_ink(d, r, g, b));
  return 1;
}


static int gdi_useink (lua_State *L) {
  int c, d;
  if (lua_gettop(L) != 2)
    luaL_error(L, "to " LUA_QS ", two arguments needed.", "gdi.useink");
  d = agn_checknumber(L, 1);
  c = agn_checknumber(L, 2);
  g2_pen(d, c);
  return 0;
}


static int gdi_background (lua_State *L) {
  int c, d;
  if (lua_gettop(L) != 2)
    luaL_error(L, "to " LUA_QS ", two arguments needed.", "gdi.background");
  d = agn_checknumber(L, 1);
  c = agn_checknumber(L, 2);
  g2_set_background(d, c);
#ifdef __WIN32
  g2_clear(d);
#endif
  return 0;
}


static int gdi_initpalette (lua_State *L) {
  g2_allocate_basic_colors(agn_checknumber(L, 1));
  return 0;
}


static int gdi_resetpalette (lua_State *L) {
  g2_reset_palette(agn_checknumber(L, 1));
  return 0;
}


static int gdi_clearpalette (lua_State *L) {
  g2_clear_palette(agn_checknumber(L, 1));
  return 0;
}


/* patched 0.31.3 for correct mouse button state values */
static int gdi_mouse (lua_State *L) {
  double x, y;
  unsigned int button;
  g2_query_pointer(agn_checknumber(L, 1), &x, &y, &button);
  lua_pushnumber(L, x);
  lua_pushnumber(L, y);
  lua_pushnumber(L, button);
  return 3;
}


static int gdi_system (lua_State *L) {
  g2_set_coordinate_system(
    agn_checknumber(L, 1), agn_checknumber(L, 2),
    agn_checknumber(L, 3), agn_checknumber(L, 4),
    agn_checknumber(L, 5));
  return 0;
}


static int gdi_autoflush (lua_State *L) {
  lua_Number d, state;
  if (lua_gettop(L) != 2)
    luaL_error(L, "Error in " LUA_QS ": two arguments required.", "gdi.autoflush");
  d = agn_checknumber(L, 1);
  state = lua_toboolean(L, 2);
  g2_set_auto_flush(d, state);
  return 0;
}


static const luaL_Reg gdi[] = {
  {"arc", gdi_arc},
  {"autoflush", gdi_autoflush},
  {"background", gdi_background},
  {"circle", gdi_circle},
  {"clearpalette", gdi_clearpalette},
  {"close", gdi_close},
  {"dash", gdi_dash},
  {"ellipse", gdi_ellipse},
  {"arcfilled", gdi_arcfilled},
  {"circlefilled", gdi_circlefilled},
  {"ellipsefilled", gdi_ellipsefilled},
  {"rectanglefilled", gdi_rectanglefilled},
  {"trianglefilled", gdi_trianglefilled},
  {"flush", gdi_flush},
  {"fontsize", gdi_fontsize},
  {"initpalette", gdi_initpalette},
  {"ink", gdi_ink},
  {"lastaccessed", gdi_lastaccessed},
  {"line", gdi_line},
  {"mouse", gdi_mouse},
  {"open", gdi_open},
  {"point", gdi_point},
  {"rectangle", gdi_rectangle},
  {"reset", gdi_reset},
  {"resetpalette", gdi_resetpalette},
  {"system", gdi_system},
  {"text", gdi_text},
  {"thickness", gdi_thickness},
  {"triangle", gdi_triangle},
  {"useink", gdi_useink},
  {NULL, NULL}
};


/*
** Open gdi library
*/
LUALIB_API int luaopen_gdi (lua_State *L) {
  luaL_register(L, AGENA_GDILIBNAME, gdi);
  return 1;
}

//#endif  /* UNIX or __WIN32 or __APPLE__ */

