# RPM building file for OpenSUSE 10.3
# ! build Agena in /home/proglang/agena !
Summary: Agena Programming Language
Name: agena
Version: 5.1.1
Release: 1
# change Release number in build.sh file, as well.
#Source0: %{name}-%{version}-src.tar.gz
License: GPL v2
Group: Development/Languages
Source: http://downloads.sourceforge.net/agena/%{name}-%{version}-src.tar.gz
Summary: Agena is a procedural programming language.
#BuildRequires: ncurses, readline, freetype, fontconfig, libpng, zlib, expat, jpeg, gd, iconv, intl, xpm, libiconv, xpm, libintl, libgd
#BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}
BuildRoot: %{_tmppath}/%{name}-%{version}
URL: http://agena.sourceforge.net
Packager: Alexander Walz
Vendor: Alexander Walz
Provides: agena libagena.so libagena.a
%description
Agena is an easy-Agena is an easy-to-learn procedural programming language designed
for science, scripting, and many other applications.

Its syntax resembles very simplified Algol 68 with elements taken from Lua
and SQL.

Agena provides fast real and complex arithmetics, efficient text processing,
flexible data structures, intelligent procedures and package management, plus
various configuration facilities.
%prep
# unpack the source and cd into the SOURCE directory
%setup -q
%build
make config
make opensuse
%install
make install
# for sanity protection, make sure the Buildroot is empty
rm -rf $RPM_BUILD_ROOT
%makeinstall
mkdir -p $RPM_BUILD_ROOT/usr/agena
mkdir -p $RPM_BUILD_ROOT/usr/agena/lib
mkdir -p $RPM_BUILD_ROOT/usr/agena/data
mkdir -p $RPM_BUILD_ROOT/usr/agena/doc
mkdir -p $RPM_BUILD_ROOT/usr/agena/share
mkdir -p $RPM_BUILD_ROOT/usr/agena/share/icons
mkdir -p $RPM_BUILD_ROOT/usr/agena/share/schemes
mkdir -p $RPM_BUILD_ROOT/usr/agena/share/scripting
mkdir -p $RPM_BUILD_ROOT/usr/local
mkdir -p $RPM_BUILD_ROOT/usr/local/bin
mkdir -p $RPM_BUILD_ROOT/usr/local/lib
mkdir -p $RPM_BUILD_ROOT/usr/lib
mkdir -p $RPM_BUILD_ROOT/usr/lib/pkgconfig
# Documentation etc.
cp /home/proglang/agena/doc/agena-crashcourse.pdf $RPM_BUILD_ROOT/usr/agena/doc
cp /home/proglang/agena/doc/agena.pdf $RPM_BUILD_ROOT/usr/agena/doc
cp /home/proglang/agena/doc/agena.xls $RPM_BUILD_ROOT/usr/agena/doc
cp /home/proglang/agena/doc/ascii.xls $RPM_BUILD_ROOT/usr/agena/doc
cp /home/proglang/agena/doc/regex.txt $RPM_BUILD_ROOT/usr/agena/doc
cp /home/proglang/agena/installers/rpmsuse/agena.pc $RPM_BUILD_ROOT/usr/lib/pkgconfig
# Data files
cp /home/proglang/agena/data/langreg.csv $RPM_BUILD_ROOT/usr/agena/data
cp /home/proglang/agena/data/viking2.csv $RPM_BUILD_ROOT/usr/agena/data
cp /home/proglang/agena/data/viking2.txt $RPM_BUILD_ROOT/usr/agena/data
cp /home/proglang/agena/data/airlines.csv $RPM_BUILD_ROOT/usr/agena/data
cp /home/proglang/agena/data/airlines.txt $RPM_BUILD_ROOT/usr/agena/data
cp /home/proglang/agena/data/sunspots.csv $RPM_BUILD_ROOT/usr/agena/data
cp /home/proglang/agena/data/sunspots.txt $RPM_BUILD_ROOT/usr/agena/data
# Libraries
cp /home/proglang/agena/lib/aconv.agn $RPM_BUILD_ROOT/usr/agena/lib
cp /home/proglang/agena/lib/aconv.so $RPM_BUILD_ROOT/usr/agena/lib
cp /home/proglang/agena/lib/ads.agn $RPM_BUILD_ROOT/usr/agena/lib
cp /home/proglang/agena/lib/ads.so $RPM_BUILD_ROOT/usr/agena/lib
cp /home/proglang/agena/lib/agenaini.spl $RPM_BUILD_ROOT/usr/agena/lib
cp /home/proglang/agena/lib/ansi.agn $RPM_BUILD_ROOT/usr/agena/lib
cp /home/proglang/agena/lib/astro.agn $RPM_BUILD_ROOT/usr/agena/lib
cp /home/proglang/agena/lib/astro.so $RPM_BUILD_ROOT/usr/agena/lib
cp /home/proglang/agena/lib/bimaps.agn $RPM_BUILD_ROOT/usr/agena/lib
cp /home/proglang/agena/lib/bimaps.so $RPM_BUILD_ROOT/usr/agena/lib
cp /home/proglang/agena/lib/bloom.so $RPM_BUILD_ROOT/usr/agena/lib
cp /home/proglang/agena/lib/clock.agn $RPM_BUILD_ROOT/usr/agena/lib
cp /home/proglang/agena/lib/clock.so $RPM_BUILD_ROOT/usr/agena/lib
cp /home/proglang/agena/lib/com.so $RPM_BUILD_ROOT/usr/agena/lib
cp /home/proglang/agena/lib/compat.agn $RPM_BUILD_ROOT/usr/agena/lib
cp /home/proglang/agena/lib/cordic.so $RPM_BUILD_ROOT/usr/agena/lib
cp /home/proglang/agena/lib/cuckoo.so $RPM_BUILD_ROOT/usr/agena/lib
cp /home/proglang/agena/lib/curses.agn $RPM_BUILD_ROOT/usr/agena/lib
cp /home/proglang/agena/lib/curses.so $RPM_BUILD_ROOT/usr/agena/lib
cp /home/proglang/agena/lib/divs.agn $RPM_BUILD_ROOT/usr/agena/lib
cp /home/proglang/agena/lib/double.agn $RPM_BUILD_ROOT/usr/agena/lib
cp /home/proglang/agena/lib/double.so $RPM_BUILD_ROOT/usr/agena/lib
cp /home/proglang/agena/lib/dual.agn $RPM_BUILD_ROOT/usr/agena/lib
cp /home/proglang/agena/lib/dual.so $RPM_BUILD_ROOT/usr/agena/lib
cp /home/proglang/agena/lib/fastmath.so $RPM_BUILD_ROOT/usr/agena/lib
cp /home/proglang/agena/lib/fractals.agn $RPM_BUILD_ROOT/usr/agena/lib
cp /home/proglang/agena/lib/fractals.so $RPM_BUILD_ROOT/usr/agena/lib
cp /home/proglang/agena/lib/gdi.agn $RPM_BUILD_ROOT/usr/agena/lib
cp /home/proglang/agena/lib/gdi.so $RPM_BUILD_ROOT/usr/agena/lib
cp /home/proglang/agena/lib/gzip.so $RPM_BUILD_ROOT/usr/agena/lib
cp /home/proglang/agena/lib/hashes.agn $RPM_BUILD_ROOT/usr/agena/lib
cp /home/proglang/agena/lib/hashes.so $RPM_BUILD_ROOT/usr/agena/lib
cp /home/proglang/agena/lib/heaps.agn $RPM_BUILD_ROOT/usr/agena/lib
cp /home/proglang/agena/lib/heaps.so $RPM_BUILD_ROOT/usr/agena/lib
cp /home/proglang/agena/lib/ival.so $RPM_BUILD_ROOT/usr/agena/lib
cp /home/proglang/agena/lib/ival.agn $RPM_BUILD_ROOT/usr/agena/lib
cp /home/proglang/agena/lib/json.agn $RPM_BUILD_ROOT/usr/agena/lib
cp /home/proglang/agena/lib/library.agn $RPM_BUILD_ROOT/usr/agena/lib
cp /home/proglang/agena/lib/mapm.agn $RPM_BUILD_ROOT/usr/agena/lib
cp /home/proglang/agena/lib/mapm.so $RPM_BUILD_ROOT/usr/agena/lib
cp /home/proglang/agena/lib/mp.agn $RPM_BUILD_ROOT/usr/agena/lib
cp /home/proglang/agena/lib/mp.so $RPM_BUILD_ROOT/usr/agena/lib
cp /home/proglang/agena/lib/mpf.agn $RPM_BUILD_ROOT/usr/agena/lib
cp /home/proglang/agena/lib/mpf.so $RPM_BUILD_ROOT/usr/agena/lib
cp /home/proglang/agena/lib/net.agn $RPM_BUILD_ROOT/usr/agena/lib
cp /home/proglang/agena/lib/net.so $RPM_BUILD_ROOT/usr/agena/lib
cp /home/proglang/agena/lib/rbtree.so $RPM_BUILD_ROOT/usr/agena/lib
cp /home/proglang/agena/lib/regex.so $RPM_BUILD_ROOT/usr/agena/lib
cp /home/proglang/agena/lib/regex.agn $RPM_BUILD_ROOT/usr/agena/lib
cp /home/proglang/agena/lib/skycrane.agn $RPM_BUILD_ROOT/usr/agena/lib
cp /home/proglang/agena/lib/skycrane.so $RPM_BUILD_ROOT/usr/agena/lib
cp /home/proglang/agena/lib/tar.agn $RPM_BUILD_ROOT/usr/agena/lib
cp /home/proglang/agena/lib/telex.agn $RPM_BUILD_ROOT/usr/agena/lib
cp /home/proglang/agena/lib/testlib.so $RPM_BUILD_ROOT/usr/agena/lib
cp /home/proglang/agena/lib/xml.agn $RPM_BUILD_ROOT/usr/agena/lib
cp /home/proglang/agena/lib/xml.so $RPM_BUILD_ROOT/usr/agena/lib
cp /home/proglang/agena/lib/zx.so $RPM_BUILD_ROOT/usr/agena/lib
cp /home/proglang/agena/lib/kiss.agn $RPM_BUILD_ROOT/usr/agena/lib
cp /home/proglang/agena/lib/maple.agn $RPM_BUILD_ROOT/usr/agena/lib
# Schema files
cp /home/proglang/agena/share/schemes/agena.lang $RPM_BUILD_ROOT/usr/agena/share/schemes
cp /home/proglang/agena/share/schemes/agena.sch $RPM_BUILD_ROOT/usr/agena/share/schemes
cp /home/proglang/agena/share/schemes/agena.xml $RPM_BUILD_ROOT/usr/agena/share/schemes
cp /home/proglang/agena/share/schemes/agena.dat $RPM_BUILD_ROOT/usr/agena/share/schemes
cp /home/proglang/agena/share/schemes/nedit.rc $RPM_BUILD_ROOT/usr/agena/share/schemes
cp /home/proglang/agena/share/schemes/readme.txt $RPM_BUILD_ROOT/usr/agena/share/schemes
cp /home/proglang/agena/share/icons/agena.ico $RPM_BUILD_ROOT/usr/agena/share/icons
cp /home/proglang/agena/share/icons/agena256.ico $RPM_BUILD_ROOT/usr/agena/share/icons
cp /home/proglang/agena/share/icons/aedit256.gif $RPM_BUILD_ROOT/usr/agena/share/icons
cp /home/proglang/agena/share/icons/aedit256.ico $RPM_BUILD_ROOT/usr/agena/share/icons
cp /home/proglang/agena/share/icons/agena.png $RPM_BUILD_ROOT/usr/agena/share/icons
cp /home/proglang/agena/share/icons/agena128x128.ico $RPM_BUILD_ROOT/usr/agena/share/icons
cp /home/proglang/agena/share/icons/agena128x128.png $RPM_BUILD_ROOT/usr/agena/share/icons
cp /home/proglang/agena/share/icons/agena64x64.ico $RPM_BUILD_ROOT/usr/agena/share/icons
cp /home/proglang/agena/share/icons/agena64x64.png $RPM_BUILD_ROOT/usr/agena/share/icons
cp /home/proglang/agena/share/icons/agena64x64.ppf $RPM_BUILD_ROOT/usr/agena/share/icons
cp /home/proglang/agena/share/icons/agena8b.gif $RPM_BUILD_ROOT/usr/agena/share/icons
cp /home/proglang/agena/share/icons/agena8b.ico $RPM_BUILD_ROOT/usr/agena/share/icons
cp /home/proglang/agena/share/icons/agenasmall.ico $RPM_BUILD_ROOT/usr/agena/share/icons
cp /home/proglang/agena/share/icons/agenasmall.png $RPM_BUILD_ROOT/usr/agena/share/icons
cp /home/proglang/agena/share/scripting/ln.agn $RPM_BUILD_ROOT/usr/agena/share/scripting
cp /home/proglang/agena/share/scripting/getopt.agn $RPM_BUILD_ROOT/usr/agena/share/scripting
cp /home/proglang/agena/share/scripting/whereis.agn $RPM_BUILD_ROOT/usr/agena/share/scripting
cp /home/proglang/agena/share/scripting/whereis.bat $RPM_BUILD_ROOT/usr/agena/share/scripting
cp /home/proglang/agena/share/scripting/whereis.cmd $RPM_BUILD_ROOT/usr/agena/share/scripting
cp /home/proglang/agena/src/agena $RPM_BUILD_ROOT/usr/local/bin
#cp /home/proglang/fltk-1.1.10/editor/agenaedit $RPM_BUILD_ROOT/usr/local/bin
cp /home/proglang/agena/change.log $RPM_BUILD_ROOT/usr/agena
cp /home/proglang/agena/src/libagena.a $RPM_BUILD_ROOT/usr/local/lib
cp /home/proglang/agena/src/libagena.so $RPM_BUILD_ROOT/usr/local/lib
cp /home/proglang/agena/src/licence $RPM_BUILD_ROOT/usr/agena
# Srglue/Sragena
cp /home/proglang/agena/ports/sragena-102/src/srglue $RPM_BUILD_ROOT/usr/local/bin
cp /home/proglang/agena/ports/sragena-102/src/sragena $RPM_BUILD_ROOT/usr/local/bin
cp /home/proglang/agena/ports/sragena-102/README.srglue $RPM_BUILD_ROOT/usr/agena
chmod -R 755 $RPM_BUILD_ROOT/usr/agena
chmod 755 $RPM_BUILD_ROOT/usr/local/bin/agena
chmod 755 $RPM_BUILD_ROOT/usr/local/bin/srglue
chmod 755 $RPM_BUILD_ROOT/usr/local/bin/sragena
chmod 755 $RPM_BUILD_ROOT/usr/local/lib/libagena.a
chmod 755 $RPM_BUILD_ROOT/usr/local/lib/libagena.so
chmod 755 $RPM_BUILD_ROOT/usr/lib/pkgconfig/agena.pc
%clean
rm -rf $RPM_BUILD_ROOT
%files
%defattr(-,root,root)
/usr/agena/doc
/usr/agena/share
# no need to specify share subdirs
# do not remove agena.ini file, so do not delete /usr/agena/lib subdirectory completely
/usr/agena/change.log
/usr/agena/licence
/usr/agena/README.srglue
/usr/agena/data/langreg.csv
/usr/agena/data/viking2.csv
/usr/agena/data/viking2.txt
/usr/agena/data/airlines.csv
/usr/agena/data/airlines.txt
/usr/agena/data/sunspots.csv
/usr/agena/data/sunspots.txt
# Libraries
/usr/agena/lib/aconv.agn
/usr/agena/lib/aconv.so
/usr/agena/lib/ads.agn
/usr/agena/lib/ads.so
/usr/agena/lib/agenaini.spl
/usr/agena/lib/ansi.agn
/usr/agena/lib/astro.agn
/usr/agena/lib/astro.so
/usr/agena/lib/bimaps.agn
/usr/agena/lib/bimaps.so
/usr/agena/lib/bloom.so
/usr/agena/lib/clock.agn
/usr/agena/lib/clock.so
/usr/agena/lib/com.so
/usr/agena/lib/compat.agn
/usr/agena/lib/cordic.so
/usr/agena/lib/cuckoo.so
/usr/agena/lib/curses.agn
/usr/agena/lib/curses.so
/usr/agena/lib/divs.agn
/usr/agena/lib/double.agn
/usr/agena/lib/double.so
/usr/agena/lib/dual.agn
/usr/agena/lib/dual.so
/usr/agena/lib/fastmath.so
/usr/agena/lib/fractals.agn
/usr/agena/lib/fractals.so
/usr/agena/lib/gdi.agn
/usr/agena/lib/gdi.so
/usr/agena/lib/gzip.so
/usr/agena/lib/hashes.agn
/usr/agena/lib/hashes.so
/usr/agena/lib/heaps.agn
/usr/agena/lib/heaps.so
/usr/agena/lib/ival.so
/usr/agena/lib/ival.agn
/usr/agena/lib/json.agn
/usr/agena/lib/library.agn
/usr/agena/lib/mapm.agn
/usr/agena/lib/mapm.so
/usr/agena/lib/mp.agn
/usr/agena/lib/mp.so
/usr/agena/lib/mpf.agn
/usr/agena/lib/mpf.so
/usr/agena/lib/net.agn
/usr/agena/lib/net.so
/usr/agena/lib/rbtree.so
/usr/agena/lib/regex.so
/usr/agena/lib/regex.agn
/usr/agena/lib/skycrane.agn
/usr/agena/lib/skycrane.so
/usr/agena/lib/tar.agn
/usr/agena/lib/telex.agn
/usr/agena/lib/testlib.so
/usr/agena/lib/xml.agn
/usr/agena/lib/xml.so
/usr/agena/lib/zx.so
/usr/agena/lib/kiss.agn
/usr/agena/lib/maple.agn
/usr/local/lib/libagena.a
/usr/local/lib/libagena.so
/usr/lib/pkgconfig/agena.pc
/usr/local/bin/agena
/usr/local/bin/srglue
/usr/local/bin/sragena
#/usr/local/bin/agenaedit
#%doc /usr/local/info/agena.info
#%doc %attr(0444,root,root) /usr/local/man/man1/indent.1
#%doc COPYING AUTHORS README NEWS
%post
#cd /usr/lib
#ln -sf ./libreadline.so.5.2 ./libreadline.so.5
#ln -sf ./libhistory.so.5.2 ./libhistory.so.5
#ln -sf ./libncurses.so.5.6 ./libncurses.so.5
echo ""
echo "The Agena binary has been put in the /usr/local/bin folder."
echo ""
echo "The Agena library files libagena.* have been put in the /usr/local/lib folder."
echo ""
echo "All other Agena files including the manual may be found in /usr/agena."
echo ""
echo "The main Agena library folder is /usr/agena/lib."
echo ""
