#! /bin/sh
# Compile and install skript for the plus package for Solaris 10 (Sparc and x86)
#
# Execute this batch file in the .../agena/src folder by typing:
# sh makeplussolaris.sh
#
# Note that libgcc_s.so and libgcc_s.so.1 must exist in /usr/lib and
# /usr/local/lib so that the modules can be used.

# delete *.o files not deleted by make clean
for i in ads.o fractals.o phq.o net.o astro.o moon.o sunriset.o skycrane.o hashes.o fastmath.o dual.o mp.o mpf.o luasys.o charbuf.o com.o heaps.o rbtree.o regex.o gzip.o xml.o testlib.o double.o bloom.o cuckoo.o clock.o zx.o bimaps.o cordic.o
do
   if [ -f i ]; then
      rm i
   fi
done

OPTIONS="-O3 -fpic -Wno-attributes -fgnu89-inline"
OPTFINAL="-O3 -shared -fpic -Wno-attributes -fgnu89-inline"

printf "Compiling ADS ... "
gcc $OPTIONS -c -o ads.o ads.c
# we need to compile and link against vector in Sun Solaris
gcc $OPTIONS -c -o vecoff64.o vecoff64.c
gcc $OPTFINAL -o ads.so ads.o vecoff64.o
printf "done.\n"

if [ -f ../phq/phq.c ]; then
   printf "Compiling phonetiQs ... "
   gcc $OPTIONS -c -o phq.o ../phq/phq.c
   gcc $OPTFINAL -o phq.so phq.o
   printf "done.\n"
   strip phq.so
   mv phq.so ../phq
fi

printf "Compiling fractals ... "
gcc $OPTIONS -c -o fractals.o fractals.c
gcc $OPTFINAL -o fractals.so fractals.o
printf "done.\n"

printf "Compiling astro ... "
gcc $OPTIONS -c -o astro.o astro.c
gcc $OPTIONS -c -o moon.o moon.c
gcc $OPTIONS -c -o sunriset.o sunriset.c
gcc $OPTFINAL -o astro.so astro.o sunriset.o moon.o
printf "done.\n"

printf "Compiling net ... "
gcc $OPTIONS -c -o net.o net.c
gcc $OPTFINAL -o net.so net.o -lsocket -lnsl
printf "done.\n"

printf "Compiling hashes ... "
gcc $OPTIONS -c -o hashes.o hashes.c
gcc $OPTFINAL -o hashes.so hashes.o
printf "done.\n"

printf "Compiling skycrane ... "
gcc $OPTIONS -c -o skycrane.o skycrane.c
gcc $OPTFINAL -o skycrane.so skycrane.o
printf "done.\n"

printf "Compiling zx ... "
gcc $OPTIONS -c -o zx.o zx.c
gcc $OPTFINAL -o zx.so zx.o
printf "done.\n"

printf "Compiling bloom ... "
gcc $OPTIONS -c -o bloom.o bloom.c
gcc $OPTFINAL -o bloom.so bloom.o
printf "done.\n"

printf "Compiling cuckoo ... "
gcc $OPTIONS -c -o cuckoo.o cuckoo.c
gcc $OPTFINAL -o cuckoo.so cuckoo.o
printf "done.\n"

printf "Compiling clock ... "
gcc $OPTIONS -c -o clock.o clock.c
gcc $OPTFINAL -o clock.so clock.o
printf "done.\n"

printf "Compiling fastmath ... "
gcc $OPTIONS -Wno-strict-aliasing -c -o fastmath.o fastmath.c
gcc $OPTFINAL -Wno-strict-aliasing -o fastmath.so fastmath.o
printf "done.\n"

printf "Compiling dual ... "
gcc $OPTIONS -c -o dual.o dual.c
gcc $OPTFINAL -o dual.so dual.o
printf "done.\n"

printf "Compiling cordic ... "
gcc $OPTIONS -c -o cordic.o cordic.c
gcc $OPTFINAL -o cordic.so cordic.o
printf "done.\n"

printf "Compiling aconv ... "
gcc $OPTIONS -std=c99 -liconv -c -o aconv.o aconv.c
gcc $OPTFINAL -std=c99 -liconv -o aconv.so aconv.o
printf "done.\n"

printf "Compiling mp ... "
gcc $OPTIONS -std=c99 -lgmp -c -o mp.o mp.c
gcc $OPTFINAL -std=c99 -lgmp -o mp.so mp.o
printf "done.\n"

printf "Compiling mpf ... "
gcc $OPTIONS -std=c99 -lmpfr -lgmp -c -o mpf.o mpf.c
gcc $OPTFINAL -std=c99 -lmpfr -lgmp -o mpf.so mpf.o
printf "done.\n"

printf "Compiling gzip ... "
gcc $OPTIONS -c -o gzip.o gzip.c
gcc $OPTFINAL -o gzip.so gzip.o -lz
printf "done.\n"

printf "Compiling xml ... "
gcc $OPTIONS -c -o xml.o xml.c
gcc $OPTFINAL -o xml.so xml.o -lexpat
printf "done.\n"

printf "Compiling regex ... "
gcc $OPTIONS -DPCRE2_CODE_UNIT_WIDTH=8 -c -o regex_f.o regex_f.c
gcc $OPTIONS -DPCRE2_CODE_UNIT_WIDTH=8 -c -o regexcom.o regexcom.c
gcc $OPTIONS -DPCRE2_CODE_UNIT_WIDTH=8 -c -o regex.o regex.c
gcc $OPTFINAL -o regex.so regex.o regex_f.o regexcom.o -lpcre2-posix -lpcre2-8
printf "done.\n"

printf "Compiling com ... "
gcc $OPTIONS -DPLUS -c -o charbuf.o charbuf.c
gcc $OPTIONS -c -o luasys.o luasys.c
gcc $OPTIONS -c -o com.o com.c
gcc $OPTFINAL -o com.so com.o charbuf.o luasys.o
printf "done.\n"

printf "Compiling heaps ... "
gcc $OPTIONS -c -o heaps.o heaps.c
gcc $OPTFINAL -o heaps.so heaps.o
printf "done.\n"

printf "Compiling rbtree ... "
gcc $OPTIONS -Wno-maybe-uninitialized -c -o rbtree.o rbtree.c
gcc $OPTFINAL -Wno-maybe-uninitialized -o rbtree.so rbtree.o
printf "done.\n"

printf "Compiling bimaps ... "
gcc $OPTIONS -Wno-maybe-uninitialized -c -o bimaps.o bimaps.c
gcc $OPTFINAL -Wno-maybe-uninitialized -o bimaps.so bimaps.o
printf "done.\n"

printf "Compiling testlib ... "
gcc $OPTIONS -c -o testlib.o testlib.c
gcc $OPTFINAL -o testlib.so testlib.o
printf "done.\n"

printf "Compiling double ... "
gcc $OPTIONS -c -o double.o double.c
gcc $OPTFINAL -o double.so double.o
printf "done.\n"

# ncurses 5.0, 5.9 and 6.1 do not compile in Solaris and the curses installation in Sol 10 misses various constants
#printf "Compiling curses ... "
#gcc $OPTIONS -Wno-discarded-qualifiers -std=c99 -lncurses -c -o curses.o curses.c
#gcc $OPTFINAL -std=c99 -lncurses -o curses.so curses.o
#printf "done.\n"

printf "Slimming and moving packages ... "
strip *.so
mv ads.so ../lib
mv fractals.so ../lib
mv net.so ../lib
mv hashes.so ../lib
mv astro.so ../lib
mv skycrane.so ../lib
mv zx.so ../lib
mv bloom.so ../lib
mv cuckoo.so ../lib
mv clock.so ../lib
mv fastmath.so ../lib
mv dual.so ../lib
mv aconv.so ../lib
mv mp.so ../lib
mv mpf.so ../lib
mv gzip.so ../lib
mv xml.so ../lib
mv regex.so ../lib
mv com.so ../lib
mv heaps.so ../lib
mv rbtree.so ../lib
mv bimaps.so ../lib
mv testlib.so ../lib
mv double.so ../lib
mv cordic.so ../lib

printf "done.\n"

echo Installed all libraries into /lib folder.
echo All done.

