/*
** $Id: lapi.h,v 2.2 2005/04/25 19:24:10 roberto Exp $
** Auxiliary functions from Lua/Agena API
** See Copyright Notice in agena.h
*/

#ifndef lapi_h
#define lapi_h

#include "lobject.h"

LUA_API void luaA_pushobject (lua_State *L, const TValue *o);
LUA_API TValue   *index2adr (lua_State *L, int idx);
LUA_API GCObject *index2gco (lua_State *L, int idx);  /* 2.9.1 */

/* 2.36.0 */
#define lua_istrue(L,idx)  (lua_isboolean(L, (idx)) && bvalue(index2adr(L, (idx))) == 1)
#define lua_isfalse(L,idx) (lua_isboolean(L, (idx)) && bvalue(index2adr(L, (idx))) == 0)
#define lua_isfail(L,idx)  (lua_isboolean(L, (idx)) && bvalue(index2adr(L, (idx))) == 2)
#define lua_isfalseorfail(L,idx) ({ \
  TValue *adr = index2adr(L, (idx)); \
  (lua_isboolean(L, (idx)) && (bvalue(adr) == 0 || bvalue(adr) == 2)); \
})
#define lua_isnilfalseorfail(L,idx) ({ \
  TValue *adr = index2adr(L, (idx)); \
  (lua_isnil(L, (idx)) || (lua_isboolean(L, (idx)) && (bvalue(adr) == 0 || bvalue(adr) == 2))); \
})

#define agn_istrue(L,idx)  (bvalue(index2adr(L, (idx))) == 1)
#define agn_isfalse(L,idx) (bvalue(index2adr(L, (idx))) == 0)
#define agn_isfail(L,idx)  (bvalue(index2adr(L, (idx))) == 2)

/* from Lua 5.4.0, unused */
#define codeNresults(n)          (-(n) - 3)
#define hastocloseCfunc(n)       ((n) < LUA_MULTRET)

#endif
