;	ROMDSK	V1.1
;
;	    RAM-,
;	     
;	 ROM-
;
; :
;	1.0.      1996 .
;	1.1.       Int13h (..'2002)
;	            Int13h  FF  9C

;	  RAM/ROM-
;
ins_drv equ	1	;      
			;  RAM-  
drive	equ	1	;      
			;  ROM-  
sectors equ	9	;    
tracks	equ	40	;    
heads	equ	2	;  

offs	equ	400h	;   ROM-  
			;    
old13h	equ	9ch	;     INT13h (..'2002)

;	 

;	     
;	     ROM-
;
	mov	si,81h	;       "/"
	cld
scan1:	lodsb
	cmp	al,0dh	;        ?
	jne	scan2
	mov	dx,offset txt1 ;   -    
			       ;  
break:	mov	ah,9	;
	int	21h	;   
	int	20h	;   
scan2:	cmp	al,'/'         ;   -   "/"
	jne	scan1	;   
	mov	cx,10	;     
			;    
	xor	ah,ah
next:	lodsb		;       
	;   .       ASCII 
	sub	al,'0'  ;     0..9
	cmp	al,cl	;     ..
			;      ?
	ja	done	;   -   
	xchg	ax,bx
	mul	cx	;   -     
	add	bx,ax	; 10       
	jmp	next	;       . 
done:	mov	dx,offset txt2 ;     
			       ;     
	test	bx,bx	;    0   ?
	jz	break	;   -      .
	cmp	bx,1024 ;  > 1024   ?
	ja	break	;   -      .
	mov	len+offs,bx ;   ( ) - 
		;       ROM-
		;  KB    512 B   ROM- 
		; (      WROM)

;	     
;	    FAT   
;	   ROM-
;
	add	bx,bx	;   ROM-    512 B
	mov	byte ptr [offs+2],bl ;   
			;     ROM- (55,AA,size)
	push	bx	;        
	dec	bx	;     
	mov	cx,1	;  FAT     1 
do:	mov	ax,bx	;       
			;  FAT
	mov	DSKsize+offs,ax ;     ROM-
			;   (     )
	dec	ax	;      
			; BOOT- (1 )
	dec	ax	;      
			;   (   1 )
	sub	ax,cx	;      
			;    FAT (   )
		;      AX      
	mov	bp,3	;
	mul	bp	;   
	mov	bp,1024 ; , 
	div	bp	;    
	test	dx,dx	;   FAT, 
	jz	_0	;      
	inc	ax	;  ROM-
_0:	xchg	ax,cx
	cmp	ax,cx	;    FAT   
			;  (  )
	jne	do	;   -    
	mov	FATsize+offs,ax ;   -    
				;	   FAT  BOOT-

;	    
;	,    
;	   ROM-
;
	xchg	ax,bx
	xor	dx,dx
	mov	bx,sectors
	div	bx ; ax=__/___
		   ; dl=(__/__)
		   ; dl -    
	mov	ms_+2,dl	;    
	mov	ms+offs+2,dl	;     
				;   
	mov	bl,heads
	div	bl ; ah=__/(__*
		   ; *_)
		   ; ah -    
		   ; al=(__/
		   ; /(__*_))
		   ; al -    
	mov	mh_+2,ah	;    
	mov	mh+offs+2,ah	;    
	mov	mt_+2,al	;   
	mov	mt+offs+2,al	;   

;	,  
;	  
;     (   ,
;	  INT 13h,
;	   , 
;	     
;	  )
;
	mov	es,[2ch] ;      
	mov	ah,49h	 ;   
	int	21h	 ;  
	xor	ax,ax
	mov	ds,ax
	les	ax,[13h*4]  ;       INT 13h
	mov	[13h*4],offset i13pr ;   INT 13h 
	mov	[13h*4+2],cs	     ;   
	mov	[old13h*4],ax	     ;   
	mov	[old13h*4+2],es      ;   INT 13h  INT F5h
	mov	ax,cs		     ;    
	add	ax,offs/10h	     ; 
	mov	cs:drvseg,ax	     ;    
				     ;   
	pop	dx	 ;       ROM-
	mov	cl,5
	shl	dx,cl	    ;     RAM-
	add	dx,offs/10h ;  
	mov	ah,31h	    ;   
	int	21h	    ;   

;	 
;	  RAM-
;	  INT 13h

;	

;	      
;
i13pr:	cmp	dl,ins_drv  ;  B:   ?
	je	rom_d_	    ;   -    RAM-
	test	dl,dl	    ;   -  A:   ?
	jnz	jump_	    ;		    -  
	;      ROM-      BIOS
	push	bx
	push	ds
	xor	bx,bx
	mov	ds,bx
	cmp	byte ptr [504h],ins_drv ;   - 
		;     A:   B:   ?
	pop	ds
	pop	bx
	je	rom_d_	    ;   -    RAM-
			    ;		    -  
	;      ROM-      BIOS

jump_:
	db	0eah		;  JMP Far
	dw	offset	i13pr2	;    
				; INT 13h    ROM-
drvseg: dw	?		;    
				;  ROM-

;	  -   
;			  
;
rom_d_: cmp	ah,3	;     ?
	jne	frmt?	;   -    
	push	bx	;  :
	push	cx
	push	dx
	push	si	;     
	push	di
	push	ds
	push	es

;	     
;	   ,   
;
	xchg	al,ah	;    --> AL
			;     --> AH
	test	cl,cl	;    0   ?
	jz	errr_	;   - 
	cmp	cl,sectors ;   -    >
			; > ___   ?
	jbe	mt_	;   -  
errr_:	mov	al,4	;   -    " "
	jmp	err+offs;     ROM-
			;     
mt_:	cmp	ch,-1	;      
			; (     .)
	jb	ok_	;  <    
	je	mh_	;  =  
	mov	al,0ch	;  >    " "
	jmp	err+offs;     ROM-
			;     

;	,       
mh_:	cmp	dh,-1	;     
			; 
	jb	ok_	;  <    
ms_:	cmp	cl,-1	;  =     
			;      
			; 
	ja	errr_	;  > 
	add	cl,ah	    ;   
	dec	cx	    ;   - 
	cmp	cl,cs:ms_+2 ;    ?
	ja	errr_	    ;   - 
	inc	cx
	sub	cl,ah

;	,      
ok_:	cmp	dh,heads ;    -
			 ;  _   ?
	jb	go_	 ;   -   
			 ;  
	mov	al,1	 ;   -    " "
	jmp	err+offs ;     ROM-
			 ;     

;	    RAM-
;
go_:	mov	si,bx	;  () 
			; - 
	xchg	ax,bx	; BX=   *100h+3
			; (  (AH) --> BH,  
			;  (AL=3) --> BL)

;	    
;	    
	mov	al,sectors*heads ; ___ *
	mul	ch		 ; * _ * #
	xor	ch,ch		 ;
	add	cx,ax		 ; + #
	mov	al,sectors	 ; + ___ *
	mul	dh		 ; * #
	add	ax,cx		 ;

;	     
	mov	cl,5		 ; * 32
	shl	ax,cl		 ; (512/10h)
	mov	dx,cs
	add	ax,dx		 ; + CS
	add	ax,offs/10h	 ; +   ROM-
				 ;   
	push	ax	;       
	xor	di,di	;   0

;	    / 
;	      X Y Z T : P Q R S       
;	X Y+P Z+Q T+R : 0 0 0 S
;	(         
;	   )
	mov	ax,es	;       AX
	pop	es	;       
	mov	dx,si	;       DX
	dec	cx	; CL=4
	shr	dx,cl	; DX=__/10h
	add	ax,dx	; ___ = __
	mov	ds,ax	; _ + __/10h
	and	si,0fh	; ___ =
			; = ___ AND 000Fh

;	      RAM-
	lea	cx,[bx-3] ; CX=   
			; (   *100h+3 - 3)
	cld
	rep	movsw	  ;   
	mov	ah,bh	  ;    
			  ;     
	jmp	exit+offs ;     
			  ;  ROM- 

frmt?:	mov	dl,drive  ;    B:.   
			  ;   ROM- .
	cmp	ah,5	  ;     ?
	jne	jump__	  ;   -   ROM- 
	dec	ah	  ;   -   ROM- 
			  ;     
jump__: jmp	jump_

;	  
;
txt2:	db	'Bad parameter. '
txt1:	db	'Parameter SIZE required',10,13
	db	'Syntax: ROMDSK/SIZE  ( Size of EPROM in K-bytes )$'

	db	13dh dup (?) ;     
			     ; 
verify1:		     ;   

;	ROM-  V1.0

	org	0

	db	55h,0aah     ;    ROM-
	db	?	     ;   ROM-   
			     ; 512 
;	 
;     (    BIOS ROM-scan    POST )
;
install:
;;;;     (--..'2002)
	push	ax
	push	ds
	push	es
;     ROM  BIOS
	mov	ax,0E5Eh	;'^'
	int	10h
;;;;
	xor	ax,ax
	mov	ds,ax
	les	ax,[13h*4]  ;       INT 13h
	mov	[old13h*4],ax	      ;   
	mov	[old13h*4+2],es       ;   INT 13h  INT F5h
	mov	[13h*4],offset i13pr1 ;   INT 13h 
	mov	[13h*4+2],cs	      ;     .
	or	byte ptr [410h],040h  ;   B:  
				      ;  
;;;;     (--..'2002)
	pop	es
	pop	ds
	pop	ax
;;;;
	retf	;     BIOS

;	    
;	    
;     (   INT 13h   
;	   BOOT-   A:.
;	     B: (ROM-) )
;
i13pr1:
;;;;				; ..'2002
	push	ax
	mov	ax,0E7Eh	;'~'
	int	10h		;   
	pop	ax
;;;;
	cmp	ah,2		;     ?
	jne	i13pr2		;   -   
				;     INT 13h
	test	dx,dx		;  A:,  0   ?
	jnz	i13pr2		;   -   
				;     INT 13h
	push	ax		;  :
	push	ds
	xor	ax,ax
	mov	ds,ax
	mov	[13h*4],offset i13pr2 ;   INT 13h 
				      ;  
	pop	ds
	pop	ax
	mov	dl,drive	;    B:
				;(. BOOT    ROM-)
	;    :

;	ROM-  -   INT 13h ( )
;	   , , , ,
;	__, __ 
;	__
;
i13pr2: cmp	ah,2	 ;  __ 
			 ;    ?
	jb	jump	 ;   -     BIOS
	cmp	dl,drive ;   -  B:   ?
	je	rom_dr	 ;	      -   
			 ;	       ROM-
			 ;	      -
jump:	int	old13h	 ;     INT 13h
	db	0cah,2,0 ; retf 2

rom_dr: push	bx
	push	cx
	push	dx
	push	si	;     
	push	di
	push	ds
	push	es
	xchg	al,ah	;    --> AL
			;     --> AH

read?:	cmp	al,2	;     ?
	jne	write?	;   -    
			;  :

;	     
;	   ,   
;
	test	cl,cl	;    0   ?
	jz	errr	;   - 
	cmp	cl,sectors ;   -    >
			; > ___   ?
	jbe	mt	;   -  
errr:	mov	al,4	;   -    " "
	jmp	short err ;   
			  ;    
mt:	cmp	ch,-1	;      
			; (     .)
	jb	ok	;  <    
	je	mh	;  =  
	mov	al,0ch	;  >    " "
	jmp	short err ;   
			  ;    

;	,       
mh:	cmp	dh,-1	;     
			; 
	jb	ok	;  <    
ms:	cmp	cl,-1	;  =     
			;      
			; 
	ja	errr	;  > 

;	,      
ok:	cmp	dh,heads ;    -
			 ;  _   ?
	jb	go	 ;   -   
			 ;  
	mov	al,1	 ;   -    " "

;	        
;
err:	xor	ah,ah
	xor	dx,dx
	mov	es,dx
	mov	di,441h  ;     
	stosb		 ;      BIOS
	xchg	al,ah	 ;    --> AH, 0 --> AL
	pop	es
	pop	ds
	pop	di	 ;   
	pop	si	 ;    
	pop	dx
	pop	cx
	pop	bx
	stc
	sti		 ;   
	db	0cah,2,0 ; retf 2.    
			 ;	    

;	    RAM-
;
go:	mov	di,bx	;  () 
			; - 
	xchg	ax,bx	; BX=   *100h+3
			; (  (AH) --> BH,  
			;  (AL=3) --> BL)

;	    
;	    
	mov	al,sectors*heads ; ___ *
	mul	ch		 ; * _ * #
	xor	ch,ch		 ;
	add	cx,ax		 ; + #
	mov	al,sectors	 ; + ___ *
	mul	dh		 ; * #
	add	ax,cx		 ;

;	     
	mov	cl,5		 ; * 32
	shl	ax,cl		 ; (512/10h)
	mov	dx,cs
	add	ax,dx		 ; + CS
	mov	ds,ax		 ;   
	xor	si,si		 ;   0

;	    / 
;	      X Y Z T : P Q R S       
;	X Y+P Z+Q T+R : 0 0 0 S
;	(         
;	   )
	mov	ax,es	;       AX
	mov	dx,di	;       DX
	dec	cx	; CL=4
	shr	dx,cl	; DX=__/10h
	add	ax,dx	; ___ = __
	mov	es,ax	; _ + __/10h
	and	di,0fh	; ___ =
			; = ___ AND 000Fh

;	    RM-  
	lea	cx,[bx-2] ; CX=   
			; (   *100h+3 - 3)
	cld
	rep	movsw	  ;   
	mov	ah,bh	  ;    
			  ;     
	jmp	short exit ;     

write?: cmp	al,3	;     ?
	je	err	;   -     
			;	     "  "
formt?: cmp	al,5	;     ?
	jne	param?	;   -  
	mov	al,3	;   -     
	jmp	err	;	     "  "
param?: cmp	al,8	;  __
			; __   ?
	jne	typ	;   -  
			;   -  :
	mov	bl,1	;  
	mov	dx,(heads-1)*100h+1 ;    
				    ; (DH)    (DL)
	mov	cx,(tracks-1)*100h+sectors ;   
	      ;  (CH)      (CL)
	jmp	short exit ; 
typ:	cmp	al,15h	;  __  ?
	jne	status	;   -  
	mov	al,2	;   -  " 
			;      "
	jmp	short quit ; 
status: cmp	al,16h	;  __
			;     ?
	jne	exit	;   -     
			;	     
	mov	al,6	;   -  "  "
	jmp	short quit ; 

;	  
;	(     )
;
exit:	xor	al,al	;      
		;         ()
quit:	xor	dx,dx	;      
			;    C, 
			;    
	mov	ds,dx
	mov	byte ptr [441h],0 ;     
				  ;    BIOS
	xchg	al,ah	 ; AH=, AL=  
	pop	es
	pop	ds
	pop	di	 ;   
	pop	si
	pop	dx
	pop	cx
	pop	bx
	sti		 ;   
	db	0cah,2,0 ; retf 2.    
			 ;	    

	db	0dbh dup (?);0e2h dup (?);0edh dup (?)	;   
				;    512 B
	db	0		;    
		;       64 KB  ROM-
		;	      (	   WROM)
len:	dw	?		;   ROM-  KB
		;	      (    WROM)
verify2:	;   

;	      RAM/ROM-

;	BOOT-
;
	jmp	$+50	;   BOOT-
	db	"ROM-DISK"
	dw	512	;    
	db	1	;    
	dw	1	;       
	db	1	;    FAT
	dw	16	;     
DSKsize dw	?	;     
	db	0f0h	;     
FATsize dw	?	;   FAT  
	dw	sectors ;    
	dw	heads	;   ()
	db	8 dup (0)
	db	drive	;      
			;     DRIVEB
	db	473 dup (0)
	db	55h,0aah;     BOOT-

;	FAT   
;
	db	0f0h,-1,-1   ;     
	db	7*512-3 dup (0) ;   ( 50 --..'2002)

;	  

;	
