/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: SUPPLDBG.H $
   $Locker: ska $	$Name:  $	$State: Exp $

	SUPPL common debugging features

	If used by an application, SUPPL and the application will use the
	same debugging driver and, therefore, debugging extends from the
	application into the functions included from SUPPL. This is
	useful especially while debugging heap actions (alloc/dealloc).

	Note #1: If NDEBUG is defined, all debugging features are turned off!
	Note #2: This #include file MUST be included at the end of the list,
	at least behind all the standard #includes referencing via '<...>'.
	Otherwise it is possible that some redefines do not work or the
	compiler will detect errors within standard include files.

	Understood debugging features:
	SUPPL_DBG_MEMORY:
		Causes that the macro chkMem performs an extensive test of
		the logical memory management of DOS and the C runtime environment.
	SUPPL_DBG_HEAP:
		Causes that the macro 'chkHeap' actively checks the local
		heap for corruption.
		chkHeap includes chkMem!
	SUPPL_LOG_MEMORY:
		Causes to redefine heap-related CLib functions (malloc, calloc,
		realloc, free,& strdup).
	SUPPL_LOG_FUNCTION:
		Note: These package was inspired by Fred Fish's DBUG package
			shipped with DMake v3+.
		When the macro SUPPL_LOG_NO_INFO is #define'ed prior including
		this header file, the macro DBG_INFO() expands to nothing.

		Causes to active all of the DBG_* macros:
		DBG_ENTER() - logs that a function was entered
		DBG_ENTER1/DBG_ENTER2() - as DBG_ENTER, *1 -> declaration, *2 -> fct
		DBG_ARGUMENTS() - logs function arguments
		DBG_RETURN_VALUES() - logs function return values
		DBG_EXIT() - logs that a function was exited
		DBG_LEAVE() - logs that a function was exited (with parameter, no log)
		DBG_LONG_RETURN() - logs that a function was exited (with param & log)
		DBG_RETURN_?() - logs that a function was exited (with param & log)
		DBG_PRINT() - logs arbitary information
		DBG_INFO() - logs arbitary information of information class "inf"
		DBG_STRING() - logs a string in information class "inf"
		DBG_CHANGE_STATE() - changes logging status
		DBG_PUSH_STATE() - duplicates current logging status
		DBG_POP_STATE() - forget current logging status & restore previous one
		DBG_TERMINATE() - terminate application with a log message

*/

#ifndef __SUPPLDBG_H
#define __SUPPLDBG_H

#include <assert.h>
#ifndef _MICROC_
#include <stdlib.h>
#endif
#include <portable.h>

/*
 *	Initialize all macros with dummy values. They are undefined later
 *	right before a debugging specific value is added.
 *	Initializing them here ensures that they are correctly set for
 *	non-debugging.
 */
#define chkHeap		;
#define chkMem		;


#ifdef NDEBUG			/* native debug support disabled? */

/* Turn off every SUPPL specific debugging feature */
#undef SUPPL_DBG_HEAP
#undef SUPPL_DBG_MEMORY
#undef SUPPL_LOG_MEMORY
#undef SUPPL_LOG_FUNCTION

#else

#ifdef SUPPL_DBG_ALL

/* Turn on every SUPPL specific debugging feature */
#define SUPPL_DBG_HEAP
#define SUPPL_DBG_MEMORY
#define SUPPL_LOG_MEMORY
#define SUPPL_LOG_FUNCTION

#endif

#endif		/* !defined(NDEBUG) */

#ifdef SUPPL_ALWAYS_DEBUG_HEAP
#define SUPPL_DBG_HEAP
#endif
#ifdef SUPPL_ALWAYS_DEBUG_MEMORY
#define SUPPL_DBG_MEMORY
#endif

#ifdef SUPPL_DBG_MEMORY

#undef chkMem
#define chkMem		suppl_testMemChain();

#endif


#ifdef SUPPL_DBG_HEAP

/* Define the macro 'chkHeap' to actively test the local heap for
   corruption. Note: The macro must be used without semicolon!
*/
#undef chkHeap
#ifdef __TURBOC__
#include <alloc.h>
#ifdef NDEBUG
#define chkHeap	suppl_testHeap();  chkMem
#else
#define chkHeap	assert(heapcheck() == _HEAPOK); chkMem
#endif
#else
#define chkHeap	chkMem
#endif

#endif

#ifdef SUPPL_LOG_MEMORY
#include "syslog.h"

/* Use internal wrappers for CLib symbols */

#ifdef malloc
#undef malloc
#endif

#ifdef realloc
#undef realloc
#endif

#ifdef calloc
#undef calloc
#endif

#ifdef free
#undef free
#endif

#ifdef strdup
#undef strdup
#endif

#define malloc(size)		suppl_malloc((size))
#define calloc(nelem,size)	suppl_calloc((nelem), (size))
#define realloc(poi,size)	suppl_realloc((poi), (size))
#define free(poi)			suppl_free((poi))
#define strdup(poi)			suppl_strdup((poi))

#endif

#ifdef SUPPL_LOG_FUNCTION

/* The following macros are defined:

	DBG_EXTENSION
		Extension of the logfile

	DBG_LIBRARY
		If redefined by the user, this macros specifies the name
		of the library, the current file is located in.
		Defaults to none.

	DBG_ALWAYS_FLUSHLOG
		If defined, the log file is flushed each time one entry has been
		written successfully into the logfile. (compile-time option
		- see INITSUPL.LOC!)

	DBG_ALWAYS_CLOSELOG
		If defined, the log file is closed each time one entry has been
		written successfully into the logfile. (compile-time option
		- see INITSUPL.LOC!)
		Use this option if system crashes corrupt the logfile or same
		entries won't appear there.

	NONE OF THESE MACROS MUST NOT BE USED WITH A TRAILING SEMICOLON!

	DBG_CLOSELOG
		Close the logfile.

	DBG_FLUSHLOG
		Flush the log file and make sure all data is written to disk
		and the directory entry has been updated.
		This function should be called each time when it is possible
		that the program is going to crash or is going to be
		asynchroneously terminated (e.g. Ctrl-Alt-Del).

	DBG_ENTER(char *function_name, char *function_class)
		Enters the function with name "function_name" and class. (see STATE)
		It must be the first statement immediately following the variable
		declaration, because it will define a variable as well.
		This macro must be pairly used with DBG_LEAVE or DBG_EXIT.
		All of the other macros won't work without DBG_ENTER.

	DBG_ENTER1
		Is the variable declaration part of DBG_ENTER()

	DBG_ENTER2(char *function_name, char *function_class)
		Is the function calling part of DBG_ENTER()

	DBG_ARGUMENTS( (char *format_spec, arguments) )
		Logs the arguments of the current function. The parameters follow
		the same rules as in DBG_PRINT. The only difference to DBG_PRINT
		is that the output can be selectively enabled/disabled.

	DBG_RETURN_VALUES( (char *format_spec, arguments) )
		Logs the retrun values of the current function. The parameters follow
		the same rules as in DBG_PRINT. The only difference to DBG_PRINT
		is that the output can be selectively enabled/disabled.

	DBG_EXIT
		Exits a void function. The "return" statement is already
		included.

	DBG_LEAVE(return_expression)
		As DBG_EXIT, but "return_expression" is passed as an argument
		to "return". The return value is NOT logged automatically.

	DBG_LONG_RETURN(type, char *format_spec, return_expression)
		This macro combines: DBG_RETURN_VALUES and DBG_LEAVE.
		Unfortunately return_expression would be evaluated twice,
		therefore it is evaluated once and stored into a temporary
		variable of the specified type; 'type' must (or, at least,
		should) be of the same type as the function returns. The
		same applies to the format specification, which is passed
		to printf().

	DBG_RETURN_#(return_expression)
		As DBG_RETURN(), '#' is the uppercase letter usually find
		within a printf()-format specification:
		#	type			format_spec
		C	char			"%c"
		S	char*			"\"%s\""
		I	int				"%d"
		U	unsigned		"%u"
		X	int				"0x%x"
		L	long			"%ld"
		UL	unsigned long	"%lu"
		F	double			"%f"
		G	double			"%g"
		P	void *			"%p"

		A 'B' may be prefixed to buffer "return_expression" within a
		temporary variable to suppress side effects and/or multiple
		evalutation of a complex expression.

	DBG_PRINT( char *information_class, (char *format_spec, arguments) )
		Logs ONE line. "format_spec" is a valid printf() format
		string and should not contain no '\n' character. Both the
		format spec and the arguments must be enclosed into
		parenthises.
		The information_class specifies whether or not this information
		is logged (see STATE).

	DBG_INFO( (char *format_spec, arguments) )
		As DBG_PRINT(), but prints message of class "inf".
		Because these macro may generate a lot of strings, they can be
		individually disable with the SUPPL_LOG_NO_INFO macro. It must
		be #define'ed prior including "suppldbg.h"

	DBG_STRING(char *string)
		As DBG_INFO(), but prints a string only

	DBG_PUSH_STATE
		Duplicates the current logging status. Any subsequent DBG_CHANGE_STATE
		will effect the newly generated status only.
		If there is no status currently, this function is ignored.

	DBG_POP_STATE
		Discards the topmost logging status and restores the previous one.
		If there is only one or none pushed status, this function is
		ignored.

	DBG_CHANGE_STATE(char *state_spec)
		Modifies the current logging status according the state_spec.
		If there is no current status, a new one will be created.
		The state_spec is a sequence of log_specs delimited by semicolons.
		A log_spec consists of a log_format_letter and arguments,
		the arguments can be delimited by commas, if necessary.
		No superflous whitespaces or such are allowed!

		The following log_format_letters are understood:

		d#		set the maximum logging depth (#: unsigned number)
				default: no limit
		f?*,...	files to be logged (*: one file name), each filename
				is prefixed by '+' enable, or '-' disable file.
				Wildcards are not allowed. The filename must be specified
				the same way as the compiler named them in their __FILE__
				macro, this is usually the fully-qualified filename.
				"+" alone logs everything (clears every previous settings),
				"-" alone logs nothing (also clears every previous settings).
				default: log everything.
		c?*,...	functions to be logged (*: one function name)
				Syntax the same as "f*,...", but the string must
				case-sensitively match the string passed to DBG_ENTER()
		l?		globally enable/disable logging (?: + enable, - disable)
		i?		indent output (?: + enable, - disable)
				If disbale the nesting level is inserted as number, otherwise
				as a repetive count of "|  " strings
		C?*,...	classes to be logged
				Syntax the same as "f*,...", but the string must either
				case-sensitively match one of the classes specified as
				function_class (DBG_ENTER) or information_class (DBG_PRINT)
				or one of the SUPPL classes:
				information classes:
					"arg" - DBG_ARGUMENTS
					"rv"  - DBG_RETURN_VALUE
					"fct" - DBG_ENTER & DBG_EXIT/DBG_LEAVE
					"inf" - informative information

				function classes:
					"env" - environment
					"mcb" - MCB
					"mem" - memory
					"str" - string
					"ini" - INI file
					"cmd" - command line handling
					"err" - error wrappers
					"dfn" - filename functions
					"fil" - FILE wrappers
					"lmt" - long mathematics
					"nls" - NLS
					"log" - syslog / logging
					"msc" - misc.

				Note: function and information classes shff!
	_letters  sysloge- long mathem"RINT)
	/* Wl			function classes:
					"env" - environment
					"mcb" - MCB
					"mem" - memory
					"str" - string
					"ini" - INI file
					"cmd" - command line handling
					"err" - error wrappers
					"dfn" - filename functions
					"fil" - FILE wrappers
					"lmt" the GPince to DBG_P FILE wrapSTATE(rwg "sup"dix =on_classfdefb" - MCcro, G_P Fusel" - FILE wrappers"" - M". E it forTATE(rw" - MC- INI fBG_P Frintf(_G_E_' efpreilength,			"lmt""C+TS
				"C+,+" - M"BG_P Fno radix o"+" - M" wrapS     o"+"!G_P F file is clos ev(the samedisable)
	 #define'. They arenction is ignorelreturn"  is igloggin "e first tion, becau evific des wri"limit
	n tion, becs NDEBUG is definetensatus(r wrappe_CODE)specific valutten success the libtten succes 0p((poi))

#endif
am is going 								\
rent fiildcro ma#defin#endif
am i	asynchr								\
rent fiildcto th#defin#endif
am ie curr									\
rd in ent fiildcEAPOK_

	D_t ent fiildc

	Defin#endif
am ie cur2(g
	 differg
	 NT
		i				\
rent fiildc - lo(GPince to DB	functionB	fuLINionB	&ent fiildc

	D	\
r	tiog
	 diff)tiog
	 NT
		idefin#endif
am ie cur(g
	 differg
	 NT
		i				\
ram ie curr										\
ram ie cur2(g
	 differg
	 NT
		ifin#endif
am i.

	DBG_RET"err )						\
ram io
		parxn = UIT
		_g
	 ,T"err )fin#endif
am idisabled.

	DBG"err )					\
ram io
		parxn = UIT
		_rv ,T"err )fin#endif
am iappe									\
r{rent fiildc	glve(&ent fiildc

	Df(*p\
r	 valid; }fin#endif
am iDBG_REst b)								\
r{rent fiildc	glve(&ent fiildc

	Df(*p\
r	 valid Est b); }fin#endif
am iDariable of the spfmt, st b)			\
r{rficatf mallocmp_var;						\
r	f mallocmp_varcharst b);					\
r	led/disabled.

	DBG_fmt, f mallocmp_var) )	\
r	led/DBG_RE f mallocmp_var )					\
r}fin#endif
am idisabl(fmt, st b)					\
r{rled/disabled.

	DBG_fmt, rst b)) )		\
r	led/DBG_RE rst b) )						\
r}cific 1in#endif
am io
		pa"ernformati"err)					\
r{s thent fiildc		Dis_1(a"ernforma)))			\
r		ent fiildc		Dis_2i"err;					\
r}coc
#endif

#ifam io
		pa"ernformati"err)					\
r{s thent fiildcIT
		_ogged a(a"ernforma)))		\
r		ent fiildc"ini"err;						\
r}coc
		Defaults to none.

	ffect tndif

#ifam iG_POP"err)						
#ifdef SUPPly, this fu"err)						
#ifdc
#endif

#ifam ied pri"err )						\
ram io
		parxn = UIT
		_"er ,T"err )fdef SUPPly, this fu is)			ine'ed prio is) )p((poi))

#endif
am iing status								\
rent fiildcp th#defin#endif
am ing the st								\
rent fiildcpop#defin#endif
am ic consists ofe fol)						\
rent fiildc_H
#de(fe fol)defin#endif
am i. They are-relerr)						\
rent fiildction, bec(e-relerr)defineLWAYS/* debugg rapseudo-ec, argRY
#define am is going 							;in#endif
am i	asynchr							;in#endif
am ie curr								;in#endif
am ie cur2(g
	 differg
	 NT
		i			;in#endif
am ie cur(g
	 differg
	 NT
		i			;in#endif
am i.

	DBG_RET"err )					;in#endif
am idisabled.

	DBG"err )				;in#endif
am iappe								 valid;in#endif
am iDBG_REst b)							 valid Est b);in#endif
am iDariable of t,f,st b)				 valid Est b);in#endif
am idisabl(f,st b)						 valid Est b);in#endif
am io
		pa"ernformati"err)				;ndif

#ifam ied pri"err )						ifdef SUPPly, this fu is)							ifdef SUPPly, ing status							;in#endif
am ing the st							;in#endif
am ic consists ofe fol)					;in#endif
am i. They are is ign					ent fiildc tus(e is igndefine chkHe== 0age of cla*******rtable.ham idisable*() ec, argRY
#define am idisableFMT_SPEC_Cin a
	#define am idisableFMT_SPEC_Svariable t#define am idisableFMT_SPEC_I side #define am idisableFMT_SPEC_Ur mult#define am idisableFMT_SPEC_Xlutation#define am idisableFMT_SPEC_Llex exp#define am idisableFMT_SPEC_ULNT( cha#define am idisableFMT_SPEC_Fon_cla#define am idisableFMT_SPEC_Gormat_#define am idisableFMT_SPEC_Pnts) )
#define am idisableBCEst b)	am iDariable of ncti, am idisableFMT_SPEC_C, rst b))
#define am idisableBSEst b)	am iDariable of ncti*, am idisableFMT_SPEC_S, rst b))
#define am idisableBIEst b)	am iDariable of ilocaam idisableFMT_SPEC_I, rst b))
#define am idisableBUEst b)	am iDariable of  the comcaam idisableFMT_SPEC_U, rst b))
#define am idisableBXEst b)	am iDariable of ilocaam idisableFMT_SPEC_X, rst b))
#define am idisableBLEst b)	am iDariable of  MCBcaam idisableFMT_SPEC_L, rst b))
#define am idisableBULEst b)	am iDariable of on.

	DBG_PRIcaam idisableFMT_SPEC_UL, rst b))
#define am idisableBFEst b)	am iDariable of (char caam idisableFMT_SPEC_F, rst b))
#define am idisableBGEst b)	am iDariable of (char caam idisableFMT_SPEC_G, rst b))
#define am idisableBPEst b)	am iDariable of , argucaam idisableFMT_SPEC_P, rst b))

#define am idisableCEst b)	am ible of am idisableFMT_SPEC_C, rst b))
#define am idisableSEst b)	am ible of am idisableFMT_SPEC_S, rst b))
#define am idisableIEst b)	am ible of am idisableFMT_SPEC_I, rst b))
#define am idisableUEst b)	am ible of am idisableFMT_SPEC_U, rst b))
#define am idisableXEst b)	am ible of am idisableFMT_SPEC_X, rst b))
#define am idisableLEst b)	am ible of am idisableFMT_SPEC_L, rst b))
#define am idisableULEst b)	am ible of am idisableFMT_SPEC_UL, rst b))
#define am idisableFEst b)	am ible of am idisableFMT_SPEC_F, rst b))
#define am idisableGEst b)	am ible of am idisableFMT_SPEC_G, rst b))
#define am idisablePEst b)	am ible of am idisableFMT_SPEC_P, rst b))

fine c
#include <pooftion classe*/
#defiSomevery pare nateon class:
	NCTIONuiste
#ifdef SUPP    oi;a) -	DBG_|       >
	cCTIONuiste
#ifdef SUPP    oi;a) -	DBG_|       >
	If redeuistelogfile

	DB  SUPP    oi;a) -	DBG_|       >
	versiistemacros sp;
	le is iist	
#ifdef SUPP    oi;	) -	DBG_|       >
ee thsof the list,such ently.

	ReturopTER2() e directe name), each /
#	Cauvalu

#ifnt fiildc
#ifdef COMPI setdoid setdnew
	DB B: ...
hunk o SUPPturns	Cauvalu

#ifnt fiildcc#ifdef COMPI setdoid setdnew
	DB B: ...
hunk os are  B: ...
hunk o SUPPtgRY
#define fnt fiildcc#ifdefnew
	DBs are define	\
rent fiildcmG_EXTENSIwned by SION
	doi the use	Cauvalu

#ifnt fiildclogfile
 COMPI setdoid setdnew
	DB B: ..., argu B: ...old
	DB B: ...
hunk o SUPPtu	Cauvalu

#ifnt fiildcrror code
*, argu B: ...old
	DPtu	Cauvalu

#ifnt fiildcle is lnctioI setdoid setdnew
	DB B: ..., 1 == B: ...
is ign;YS_FLUSHsof the list,onlytituecs NDEBUssocibecauandling
				
	cCTIifnt fiildc*P_STptr  /
#	Cauvalu

#i*LOG_FUNCTION
B: ...
hunk o SUPPtu	Cauvalu

#i*d:

	DBG_EXTEB: ...
hunk os are  B: ...
hunk o SUPPtu	Cauvalu

#i*d:

	Dlogfile
 COMPoid setdt	DB B: ...
hunk o SUPPtu	Cauvalu

#ifnt firror  COMPoid setdt	DPtu	Cauvalnction nt file is lB: ..., 1 == B: ...
is ign;YS_FLFndling
			S	() =i function,MCLib fEBUG
class)
		Eisk
		aDOS Af so, NDEBUG is define	F	dion, becau/
#	Cauvalu

#ifnt fifdef NDEBUG
#       	Cauvalu

#ifnt fifdefundef       S_FLUSHsof the list,
					"dbackeatures:
	SUas "f*,G_* macr/
#le) + (ion.

	DBGent fiildc"vfifgit(cas
				functioficat/
#le) + (ion.

	DBG MCB
ent fiildc"inenrifgit(ct: log evassest ffblkficat/
#le) + (iB: ..., 1 == fnt fiildclptrifgit(c stringse lette/
#le) + (iB: ..., 1 == B: ...
nt fiildcclptrifgit(c stringse lette/
#le) + (ioid ctr{
rent fiildc"vfifrent fii_prv_as
	uncti;
	FLAG			ent fii_prv_g
	 ogged a;
rent fiildclptrif.
nt fii_g
	diff;
} ent fiildcEAPOK_

	D_t;dif

#ifnt fiildc - lo(ent fiildclptrif.FILE wr_e.
			,.
nt fiildcclptrifCcro,_e.
			,.
nt fiildc"inenrif "inenr		,.
nt fiildc"APOK_

	D_t *

	D		,.
nt fiildcclptrifCche only diff		,.
nt fiildcclptrifCche only NT
		i;if

#ifnt fiildc	glve(
nt fiildc"APOK_

	D_t *

	D characent fiildcIT
		_ogged a(
nt fiildcclptrifCIT
		diff);if

#ifnt fiildc	og(
nt fiildcclptrifCfmt, ... characent fiildc		Dis_1(
nt fiildcclptrifC"ernforma);if

#ifnt fiildc		Dis_2(
nt fiildcclptrifCfmt, ... chf

#ifnt fiildc	 th#       f

#ifnt fiildc	op#       f

#ifnt fiildc_H
#de(
nt fiildcclptrifCe fol)  f

#ifnt fiildcto th#       f

#ifnt fiildc_o ma#       f

#ifnt fiildction, bec(
nt fiildcclptrifC-relerr)  f

#ifnt fiildc tus(
nt fiildcclptrifC-relerr)  

fine cSthe SUures:
	Swrappers
					"lpart of DBG
co nonne cnto the to r: ..antessary
	cura) +=s cloablelengtix od filenamne c allowse c = wnHEAPOK)e: Exp $

	Ste applicatc =

	DBturn va
u/
#	CauvalB: ..., 1 =xn = UUG m SU[];#	CauvalB: ..., 1 =xn = Ucmff!
U[];#	CauvalB: ..., 1 =xn = Udfn[];#	CauvalB: ..., 1 =xn = Udy ..r[];#	CauvalB: ..., 1 =xn = Uenv[];#	CauvalB: ..., 1 =xn = Uege- [];#	CauvalB: ..., 1 =xn = Ufarmem[];#	CauvalB: ..., 1 =xn = Uinienam[];#	CauvalB: ..., 1 =xn = Uinienam1[];#	CauvalB: ..., 1 =xn = Uinienam2[];#	CauvalB: ..., 1 =xn = Uinienam3[];#	CauvalB: ..., 1 =xn = Umcb[];#	CauvalB: ..., 1 =xn = Umisc[];#	CauvalB: ..., 1 =xn = Unls[];#	CauvalB: ..., 1 =xn = UhkHeap		[];#	CauvalB: ..., 1 =xn = Uo non[];#	CauvalB: ..., 1 =xn = U
nt fio[];#	CauvalB: ..., 1 =xn = U
		"in[];#	CauvalB: ..., 1 =xn = Uus [];#
fine cSthe SUures:
	S nat					"lpart of DBG
co nonne cnto the to r: ..antessary
	cura) +=s cloablelengtix od filenamne c allowse c = wnHEAPOK)e: Exp $

	Ste applicatc =

	DBturn va
u/
#	CauvalB: ..., 1 =xn = UIT
		_g
	[];#	CauvalB: ..., 1 =xn = UcT
		_rv[];#	CauvalB: ..., 1 =xn = UcT
		_g
	[];#	CauvalB: ..., 1 =xn = UcT
		_ler[];#	CauvalB: ..., 1 =xn = UcT
		_env[];#	CauvalB: ..., 1 =xn = UcT
		_mcb[];#	CauvalB: ..., 1 =xn = UcT
		_mem[];#	CauvalB: ..., 1 =xn = UcT
		_..r[];#	CauvalB: ..., 1 =xn = UcT
		_lei[];#	CauvalB: ..., 1 =xn = UcT
		_cmf[];#	CauvalB: ..., 1 =xn = UcT
		_err[];#	CauvalB: ..., 1 =x