procedure AddToList(AList : PStringList; AItem : String);
begin
    (* Add Item to include list *)
    if AItem = '.' then AItem := WildCard;
    if (Copy(AItem, Length(AItem) - 1, 2) = '..') then AItem := TailDelim(AItem);
    CheckMemory(Sizeof(TStringItem));
    AList^.Add(New(PStringItem, Create(AList, AItem)));
end;

procedure InsertInList(AList : PStringList; AItem : String);
begin
    CheckMemory(Sizeof(TStringItem));
    IncludeList^.Insert(New(PStringItem, Create(AList, AItem)),nil)
end;

procedure FileToList(AList : PStringList; AFileName : String);
var
    F : PDiskFile;
    Error : Integer;
    S, LI : String;
    M : boolean;
begin
    CheckMemory(Sizeof(TDiskFile));
    F := New(PDiskFile, Create(nil));
    F^.SetMode(flRead);
    F^.Assign(AFileName);
    if F^.Result = 0 then F^.Reset;
    LI := KeyValueOnly(FetchMessage('LIST_ITEM'));
    if AList = IncludeList then
        S := KeyValueOnly(FetchMessage('LIST_INC'))
    else if AList = ExcludeList then
        S := KeyValueOnly(FetchMessage('LIST_EXC'))
    else
        S := '';
    MaybeTextLn(mcGeneral, ParseMessage('LIST_FILE', S + FormatDelim + AFileName));
    while (F^.Result = 0) and (not F^.EOF) do begin
        F^.ReadLn(S, Sizeof(S));
        S := Trim(S);
        if S <> '' then begin
            AddToList(AList, S);
            if LI <> '' then
                MaybeTextLn(mcVerbose, ParseKeyValue(LI, S));
        end;
    end;
    Error := F^.IOResult;
    Dispose(F, Destroy);
    if Error <> 0 then
        ShowError('', IntStr(Error) + FormatDelim + AFileName , Error, True);
end;

procedure SetSliceSize(ASize : String);
var
    I, E : integer;
    Size : LongInt;
    S : String;
begin
    Size := -1;
    for I := 1 to Length(ASize) do
        if (ASize[I] < '0') or (ASize[I] > '9') then begin
            Val(Copy(ASize, 1, I - 1), Size, E);
            Break;
        end;
    if Size = -1 then begin
        Val(ASize, Size, E);
        I := Length(ASize) + 1;
    end;
    if E = 0 then begin
        S := Trim(UCase(Copy(ASize, I, Length(ASize))));
        if (S='') or (S = 'B') or (S = 'BYTE') or (S= 'BYTES') then begin
        end else if (S = 'K') or (S = 'KB') or (S = 'KIB') or (S='KBYTE') or (S='KILOBYTE') then begin
            Size := Size * 1024
        end else if (S = 'M') or (S = 'MB') or (S = 'MIB') or (S = 'MBYTE') or (S = 'MEGABYTE') then begin
            Size := Size * 1024 * 1024
        end else if (S = 'G') or (S = 'GB') or (S = 'GIB') or (S = 'GBYTE') or (S = 'GIGABYTE') then begin
            Size := Size * 1024 * 1024 * 1024
        end else
            E := 1;
    end;
    for I := 0 to High(Floppies) do
        if (Floppies[I].Name = UCase(ASize)) then
            begin
                Size := Floppies[I].Bytes;
                E := 0;
                Break;
            end;
    if E <> 0 then
        ShowError('BAD_INT', SwitchChar + '|s|' + ASize, erCommand_Line_Error, True);
    for I := 0 to High(Floppies) do
        if (Floppies[I].Name = ASize) then begin
            Size := Floppies[I].Bytes;
            Break;
        end;
    if (Size < 1024) or (Size > 1024 * 1024 * 1024) then
        ShowError('BAD_VAL', SwitchChar + '|s|' + ASize + FormatDelim +
        FilterChar(SizeStr(1024), ' ') + FormatDelim +
        FilterChar(SizeStr(1024 * 1024 * 1024),  ' '), erCommand_Line_Error, True);
    Slicing := Size;
end;

procedure SetCategory(ACategory : String);
begin
    Category := ACategory;
end;

procedure ParseCmdLn;
var
    I : integer;
    P : String;
    NextIsSpecial : byte;
begin
    NextIsSpecial := 0;
    I := 1;
    while I <= ParamCount do begin
        P := ParamStr(I);
        if NextIsSpecial > 0 then begin
            case NextIsSpecial of
                1 : Archive := ParamStr(I);
                2 : AddToList(IncludeList, P);
                3 : AddToList(ExcludeList, P);
                4 : FileToList(IncludeList, P);
                5 : FileToList(ExcludeList, P);
                6 : SetSliceSize(P);
                7 : begin
                    LoadLanguage(P);
                    EmbedLang := Ucase(Trim(P));
                end;
                8 : SetCategory(P);
                9, 11 : begin { Add message to Archive }
                    if Embedded <> '' then
                        ShowError('BAD_EMB', SwitchChar + FormatDelim  + 'M' +
                        FormatDelim +  Embedded + FormatDelim + P, erCommand_Line_Error, True);
                    Embedded := P;
                    EmbedConf := NextIsSpecial = 11;
                end;
                10 : begin
                    Output := TailDelim(P);
                end;
                12 : begin
                	P := UCase(P);
           			Compression := $ffff;
                	if P = 'OFF' then
                		Compression := cpNone
                	else if P = 'GZ' then begin
						CompressApp := FindExecutable('gzip.exe');
                		if CompressApp <> '' then
                			Compression := cpGZip;
                	end;
					if Compression = $ffff then
                        ShowError('BAD_CMP', SwitchChar + FormatDelim + 'p' +
                        FormatDelim + P, erCommand_Line_Error, True);
                end;
            end;
            NextIsSpecial := 0;
        end else begin
            while P <> '' do begin
                MissingSpecial(NextIsSpecial);
                if P[1] = SwitchChar then begin
                    {$IFOPT D+}
                    if (P[2] = '!') then
                        DebugMode := True
                    else
                    {$ENDIF}
                    if (P[2] ='h') or (P[2] = '?') then begin
                        ShowHelp;
                        Halt(0);
                    end else if (P[2] = 'q') then begin
                        Dec(Verbose);
                    end else if (P[2] = 'v') then begin
                        Inc(Verbose);
                    end else if (P[2] = 't') then begin
                        Testing := True;
                    end else if (P[2] = 'd') then begin
                        NoEmptyDir := True;
                    end else if (P[2] = 'D') then begin
                        NoSubDir := True;
                    end else if (P[2] = 'a') then begin
                        Attribs := Attribs or faSystem or faHidden;
                    end else if (P[2] = 'o') then begin
                        Overwrite := 1;
                    end else if (P[2] = 'k') then begin
                        CheckCase := 1;
                    end else if (P[2] = 'y') then begin
                        AcceptAll := 1;

                    end else if (Pos(P[2], spSwitches) > 0) then begin
                        NextIsSpecial := Pos(P[2], spSwitches);
                    end else if (Pos(P[2], pmSwitches) > 0) then begin
                        if ExecMode <> pmUnknown then
                            ShowError('BAD_CMB', SwitchChar + FormatDelim  + P[2] +
                            FormatDelim +  pmSwitches[ExecMode], erCommand_Line_Error, True)
                        else
                            ExecMode := Pos(P[2], pmSwitches);
                    end else begin

                        ShowError('BAD_OPT', SwitchChar + FormatDelim  + P[2], erCommand_Line_Error, True);
                    end;

                    if Length(P) > 2 then begin
                        Delete(P, 2, 1);
                    end else
                        P := '';
                end else begin
                    AddToList(IncludeList, P);
                    P := '';
                end;
            end;
        end;
        Inc(I);
    end;
    MissingSpecial(NextIsSpecial);
end;