unit Paint2U;

Interface
 uses Crt, VGA2, Mouse, Yd;

Type
  YMGHeader = Record
                 Px, Py    : Integer;
                 s         : string[3];
              End;


  YPCHeader = Record
                 Buff : Array[1..90,1..90] of Byte;
              End;

Procedure Draw_IMGM(IMG_P : Pointer; x, y : Integer);

Procedure Draw_IMG(ImgFName : String; x, y : Integer);

Procedure SavePic2(FileName : String; x, y, px, py : Integer);

Procedure Draw_YMGP(IMG_P : Pointer; x, y, x1, y1 : Integer);

Procedure NEW;

Procedure FILED;

Procedure SAVE;

Procedure ZOOM;

Procedure PEN;

Procedure BRSH;

Procedure QUIT;

Procedure RECT;

Procedure PLINE;

Procedure PCIRCLE;

Procedure FillDat;

Procedure Load_YPC(x,y : integer; filename : string);

Implementation

Procedure NEW; external;
{$L new.obj}

Procedure FILED; external;
{$L File.obj}

Procedure SAVE; external;
{$L save.obj}

Procedure ZOOM; external;
{$L zoom.obj}

Procedure PEN; external;
{$L pen.obj}

Procedure BRSH; external;
{$L brsh.obj}

Procedure QUIT; external;
{$L exit.obj}

Procedure RECT; external;
{$L rect.obj}

Procedure PLINE; external;
{$L line.obj}

Procedure PCIRCLE; external;
{$L circle.obj}

Procedure FillDat; external;
{$L fill.obj}

Procedure Draw_IMG(ImgFName : String; x, y : Integer);
var
 IMG : YMGHeader;
 P   : Pointer;
 F   : File;
 x1, y1 : Integer;
Begin
   HideMouse;
   Assign(F,ImgFName);
   Reset(F,1);
   BlockRead(F,IMG,SizeOf(IMG));
   x1 := IMG.Px;
   y1 := IMG.Py;
   GetMem(P,(x1-2)*(y1-18));
   BlockRead(F,P^,(x1-1)*(y1-17));

   PutSprite(P,X,Y,(x1-2),(y1-18),vvga);
   Close(F);
   ShowMouse;
End;

Procedure Draw_IMGM(IMG_P : Pointer; x, y : Integer);
var
 x1, y1 : Integer;
Begin
   x1 := 42;
   y1 := 62;
   HideMouse;
   PutSprite(IMG_P,X,Y,(x1-2),(y1-18),vvga);
   ShowMouse;
End;

Procedure Draw_YMGP(IMG_P : Pointer; x, y, x1, y1 : Integer);
Begin
   HideMouse;
   PutSprite(IMG_P,X,Y,(x1-2),(y1-18),vvga);
   ShowMouse;
End;


Procedure SavePic2(FileName : String; x, y, px, py : Integer);
var
 IMG : YMGHeader;
 P   : Pointer;
 F   : File;
Begin
   HideMouse;
   GetMem(P,(Px-(x+1))*(Py-(y+1)));
   GetSprite(P,x+1,y+1,(Px-(x+1)),(Py-(y+1)),vvga);
   IMG.Px := Px;
   IMG.Py := Py;
   IMG.S := 'ymg';
   Assign(F,FileName);
   Rewrite(F,1);
   BlockWrite(F,IMG,SizeOf(IMG));
   BlockWrite(F,P^,(Px-x)*(Py-y));
   Close(F);
   ShowMouse;
End;


Procedure Load_YPC(x,y : integer; filename : string);
var
 F   : file;
 YP  : YPCHeader;
 i,j : integer;
begin
   Assign(f,FileName);
   Reset(F,1);
   BlockRead(F,YP,SizeOf(YP));
   Close(F);
   for j := 1 to 90 do
    for i := 1 to 90 do
    begin
       if YP.Buff[j,i] <> 0 then
         putpixel(x+i+1,y+j+17,YP.Buff[j,i],vvga);
    end;
end;

End.
