unit GrpTools;

{

****************************************************
* GrpTools!!  (for Turbo pascal 7.0 for dos)       *
* -----------                                      *
* Yotam's Graphics unit. (1997)                    *
* now you can use yotam's graphics procedures &    *
* functions!                                       *
****************************************************

  This unit includes:
  --------------------
         A very usefull graphics procedures and functions

         Like:
         -----
          Windows procedures & functions,
          Applications(GYApplication),
          Input Procedure(GRead, Intext or TEdit),
          GRAPH.TPU procedures,
          and more...

         GYApplication
         -------------
          GYApplication it's an object to display windows,
          dialogs messages and more.
          it's works like windows 3.X programming.


  To make this unit to .TPU file you need to have:

      Files:
     --------
         GRAPH.TPU
         YD.TPU or YD.PAS
         TOOLS1.TPU or TOOLS1.PAS
         BGIDRIV.TPU
         BGIFONT.TPU
         MOUSE.TPU
         TURBO.TPL

      Other:
     --------
         Turbo Pascal 6.0 - 7.0 or
         TPC.EXE (Turbo Pascal Compiler) version 6.0 - 7.0

      Compile GrpTools
     ------------------
      If you have a Turbo Pascal 7.0, run the pascal
      editor, open the file GRPTOOLS.PAS and then press F9.

      If you have just the compiler (TPC.EXE) then
      Set up your MS-DOS Command Prompt and Type:

       TPC /m GRPTOOLS.PAS

      (make shoure that you are in the compiler directory)
      this will make the unit and you'l be able to use it.

     Information abaut GrpTools
     ---------------------------
      You'l find more information in hebrew about this unit
      at the file:"EXMP.TXT" this file includes examples to
      use GrpTools functions & procedures.
      and hebrew information abaut it.

      I need HELP!!!
     ----------------
      If you don't know how to
      use the GrpTools unit,
      then call Yotam Madem:

     * if you don't live in israel dial
         Telephone : 972-04-8341751.

     * if you live in israel but you don't live in haifa dial
         Telephone : 04-8341751.

     * if you live in haifa dial
         Telephone : 8341751.

     I will try to help you...

     but remember!
     --------------
     I don't speak english well, I speak hebrew.
     so if you don't speak hebrew,
     I am not shure that I will be able to help you.
}

Interface

 uses Graph, Crt, BGIDriv, BGIFont, Mouse, Dos;
Type
  SingleChar = Array[1..10,1..10] of Boolean; {10x10}
  TFont      = Array[1..105]  of SingleChar;
  FontFile   = file of TFont;
  FPointer   = ^TFont;

      YPCHeader = Record
                    Buff : Array[1..90,1..90] of Byte;
                 End;


 var
  GDriver, GMode : Integer;
  Yes, No, SvYes, SvNo, Ok : String;
  GTextColor, GBkColor : Byte;
  LastStatus : String;
  BTC        : Byte;
  Font       : TFont;
  PixYSize   : Integer;
  PixXSize   : Integer;
  MaxScrX    : Integer;
  MaxScrY    : Integer;
  MinScrX    : Integer;
  MinScrY    : Integer;
  DispSColor : Byte;
  Dc         : Byte;

Type
  Buf = Array[1..20] of String;

Type
  Pic = record
     Asc: Array[1..50,1..80] of Char;
     Color, BkColor: Array [1..50,1..80] of integer;
     Password:String;
     P: integer
  End;

  Const
     Esc_Key   : Char = Chr(27);
     Enter_Key : Char = Chr(13);
     No_Key    : Char = Chr(0);
     Up_Key    : Char = #72;
     Down_Key  : Char = #80;
     Right_Key : Char = #77;
     Left_Key  : Char = #75;
     BackSpace : Char = #8;
     PgUp_Key  : Char = 'I';
     PgDn_Key  : Char = 'Q';
     Home_Key  : Char = 'G';
     End_Key   : Char = 'O';
     Tab_Key   : Char =  #9;
     F1_Key    : Char = ';';
     F2_Key    : Char = '<';
     F3_Key    : Char = '=';
     F4_Key    : Char = '>';
     F5_Key    : Char = '?';
     F6_Key    : Char = '@';
     F7_Key    : Char = 'A';
     F8_Key    : Char = 'B';

 {-----GYApplication constants----}
 Const
   ID_Exit = 1;
   ID_Help = 2;
   ID_New = 3;
   ID_Abaut = 4;
   ID_Ok = 5;
   ID_Cancel = 6;
   ID_Abort = 7;
   ID_Retry = 8;
   ID_Ignor = 9;
   ID_Close = 10;
   ID_Open = 11;
   FMaxX = 10;
   FMaxY = 10;

   Errors : Array[1..3] of String =
    ('PIC: file not found',
     'PIC: Picture number to big/small',
     'PIC: Invalid file type');

   NumErrors = 3;

{------------------------GYApplication types------------------------------}
 Type
   Button = record
   X, Y, X1, Y1 : Integer;
   Name, Status : String;
   ID : Integer;
   HotKey : Char;
   PicFName : String[12];
   Color : Byte;
 End;

 Boolean2 = (T, F, Pushed);


{---------------------Graphics Functions and procedures-------------------}

 Procedure HalonGraph(X2,Y2,X1,Y1,Hef,Col,Mcol:integer); {Drawing window}
 Procedure InText(var R:String;Max,Color,BColor:integer); {Input text}
 Procedure Load_Pic_Grp(X,Y,X1,Y1,C0:integer;File_Name:String); {Display pictures (.PIC) type}
 Procedure OutTextLn(S:String); {Like Graphics Writeln}
 Procedure GrpView(FileName,Asc:String); {Text View (from file)}
 Procedure InitGDriver; {Init the graphics screen}
 Procedure Ln(Kir:Boolean); {Down line}
 Procedure GRead(var S:String;Max:Byte); {An other input text procedure}
 Procedure GDispStr(S:String); {Like OutText}
 Procedure Disp(S : String); {A very cool display string procedure}
 Procedure FlyText(Text : String; Y : Integer);
 Function  GOpenDialog(What : String) : String;
 Procedure LoadPicComm(FName : String);
 Function  Password_Entery(P : String) : Boolean; {Passeord entery dialog}
 Procedure GLoadFont(FntName : String);
 Procedure LoadFontMem(F : FPointer);
 Procedure GOutFont(Str : String);
 Procedure GOutFontLn(Str : String);
 Procedure LYpc(X,Y,X1,Y1 : Integer;C0: Boolean;File_Name:String);
 Procedure DefaultYFont;
 Procedure SetFontSize(SizeX, SizeY : Integer);

{--------------------GYapplication Functions & Procedures-------------------}

 Function  ChekButton(B : Button; X, Y : Integer):Boolean; {Cheking the mouse touch}
 Procedure InitYesNo(Y, N:String); {Init the GYApp Yes and No defaults}
 Procedure ReturnYesNo; {Return the old defaults (GYApp Yes and No)}
 Procedure DrawStatusLine; {Status drawing}
 Procedure ShowStatus(SStr : String); {Out status text}
 Function  GetMGX : Word; {Returns Graphics mouse X }
 Function  GetMGY : Word; {Returns Graphics mouse Y }
 Procedure Draw_Button(B : Button; BColor : Byte ;Mesuman : Boolean2); {Drawing Button}
 Function  PressButton(B : Button;BColor : Byte) : Boolean; {Chek Button Pressed}
 Procedure ButtonRect(B:Button); {Drawing the button rectangle}
 Function  GQuestion(Msg, Title : String) : Boolean; {Ask the user question}
 Procedure GMessage(Msg, Title : String); {Show message in a nice window}
 Procedure ShowError(Num : Integer);
 Function  TPressButton(B : Button) : Boolean;

{----------------GRAPH.TPU Basic Procedures & Functions----------------------}

 Procedure Rectangle(X,Y,X1,Y1 : Integer);
 Procedure Circle(X,Y,Ratio : Integer);
 Procedure PutPixel(X,Y,Color : Integer);
 Procedure GPutPixel(X,Y : Integer);
 Procedure Bar(X,Y,X1,Y1 : Integer);
 Procedure Bar3D(x1, y1, x2, y2: Integer; Depth: Word; Top: Boolean);
 Procedure Line(X,Y,X1,Y1 : Integer);
 Procedure LineTo(X,Y : Integer);
 Procedure SetFillStyle(I1, I2 : Byte);
 Procedure FloodFill(X,Y,MC : Integer);
 Procedure SetFont(Font, Godel : Integer);
 Procedure CloseGraph;
{--------------------------Other Functions & procedures--------------------}

Procedure ProcPrmStr (Prms : String; var Buffer : Buf);
{---------------------------------Types--------------------------------------}

Type

GrpScroll = object  {To scroll lines and let the user to choose}
  X1,Y1,X2,Y2,I,SX,SY,C: Integer;
  From_P,To_P,Max,H:integer;
  Col,BCol,SCol:integer;
  EOFile:Boolean;
  FileName:String;
  Result:String;
  Ok    : Boolean;
  List:Array[1..20] of String;
  RoundBtn  : Button;
  UpB, DnB  : Button;
  Buttons   : Array[1..20] of Button;
  Procedure MoveSaman(A:integer);
  Procedure Menu;
  Procedure MoveScroll(A:integer);
  Procedure ReadFile;
  Procedure Drow(AA:integer);
  Procedure Init(Hef, PMax, CC,B,S:integer; PFName : String);
End;

WinGrp = object {GYApplication window object}
  X,Y,X1,Y1 : Integer;
  CloseButton : Button;
  Title : String;
  Size : Word;
  P : Pointer;
  Saving : Boolean;
  Fill, TFill, TC : Byte;
  Procedure Init(PX, PY, PX1, PY1, PFill, PTFill, PTC:Integer;PTitle:String);
  Procedure Disp;
  Procedure Erase;
  Procedure Move_Win;
End;

Dialog = Object {Buttons menu manager}
  Buttons : Array[1..30] of Button;
  Result : Integer;
  R2 : Button;
  BColor : Byte;
  Count : Byte;
  W : WinGrp;
  Procedure Init(var PW : WinGrp);
  Procedure Add_Button(X, Y : Integer; Name : String;ID : Integer);
  Procedure Disp_Buttons;
  Procedure Play;
End;

GYApplication = Object {Yotam's windows vision}
  W : WinGrp;
  D : Dialog;
  QTitle : String;
  QuitStr : String;
  ExitApp : Boolean;
  Constructor Init;
  Procedure InitMainWindow; virtual;
  Procedure InitButtons; virtual;
  Procedure StartUp; virtual;
  Procedure Case_Procedure; virtual;
  Procedure Run;
  Procedure Done; virtual;
  Procedure InitQStr; virtual;
  Procedure InitOther; virtual;
  Procedure ExitApplication;
End;

Page2 = Object {Scrolling text}
  FName     : String;
  FromP,ToP : Integer;
  Max, Count: Integer;
  Sx, Sy    : Integer;
  Color     : Byte;
  BColor    : Byte;
  Procedure Init(FN : String; Col, BCol : Byte; M : Integer);
  Procedure Read_Page(N : Boolean);
  Procedure Display;
End;

GPic = Object
          P : Pic;
          Image  : Pointer;
          Size   : Word;
          Error  : Integer;
          X, Y,
          X1,Y1  : Integer;
          PicBtn : Button;
          Procedure Load(FName : String; PNum : Integer);
          Procedure Disp(PX, PY, PX1, PY1: Integer);
          Procedure Erase;
          Procedure DispFullScr;
          Procedure Load_Mem(Pic_Data : Pointer);
       End;

 RType = (Enter, Esc, ButtonD);

 TEdit = Object
           Sx, Sy   : Integer;
           Color    : Byte;
           BColor   : Byte;
           Max      : Integer;
           S        : String;
           Btn      : Button;
           SamanPos : Byte;
           SLen     : Byte;
           Done     : Boolean;
           Ch       : Char;
           I        : Byte;
           Pass     : Boolean;
           SvS      : String;
           Result   : RType;
           Procedure DispLine(E : Boolean);
           Procedure DrawSaman;
           Procedure Init(PS : String; PBCol, PMax: Byte;X,Y : Integer);
           Procedure DrawBox;
           Procedure Edit;
         End;

{---------------------------Here is the source...---------------------------}
{------------------<<<<<<<<<<}Implementation{>>>>>>>>>>---------------------}

Procedure Beep(SS,DD,D2: integer);
  Begin
     Sound(SS);
     Delay(DD);
     NoSound;
     Delay(D2);
  End;

Procedure UpCaseStr(var S:String);
var
 I:integer;
Begin
   for i := 1 to Length(S) do S[i] := UpCase(S[i]);
End;

Function Num(Ch: String) : integer;
  var
    I,I2,I3 : integer;
    II,II2  : integer;
  Begin
     Num := 0;
     II := 0;
     II2 := 0;
     I2 := Length(Ch);
     I3 := 1;
     for I := 1 to Length(Ch) do
     Begin
        II := (Ord(Ch[I2]) - Ord('0')) * I3;
        II2 := II2 + II;
        I2 := I2 - 1;
        I3 := I3 * 10;
     End;
     Num := II2;
End;

Procedure DelayT(TD: integer);
var
h, m, s, h1, h2 : Word;
DoneD: Boolean;
I: integer;
Begin
   I := 0;
   DoneD := False;
   repeat
      h2 := h1;
      GetTime(h, m, s, h1);
      if h1 <> h2  then I := I + 1;
      if I = TD then DoneD := True;
   until DoneD;
End;

Function Exist(FName : String) : Boolean;
var
 F : file;
Begin
   Assign(F, FName);
   {$I-}Reset(F);{$I+}
   if IOResult = 0 then
   Begin
      Exist := True;
      Close(F);
   End
  else Exist := False;
End;

Procedure SetSColor(D, C:Byte);
Begin
   DispSColor := C;
   Dc := D;
End;


Function YGetDir : String;
var
 S:String;
Begin
   GetDir(0, S);
   if S[Length(S)] = '\' then
     Delete(S, Length(S), 1);
   YGetDir := S;
End;


Function ClearNum(Num : LongInt) : String;
var
 S : String;
 C, J, I : Byte;
Begin
   Str(Num, S);
   if Length(S) > 3 then
   Begin
      C := 1;
      J := Length(S);
      for I := 1 to Length(S) do
      Begin
         Inc(C);
         J := J -1;
         if (C = 3) and (J > 1) then
         Begin
            Insert(',',S,J);
            C := 0;
         End;
      End;
   End;
   ClearNum := S;
End;



Procedure HalonGraph(X2,Y2,X1,Y1,Hef,Col,Mcol:integer);
begin
   SetColor(15);
   Rectangle(X1, Y1, X2, Y2);
   Rectangle(X1 + Hef, Y1 + Hef, X2 - Hef, Y2 - Hef);
   SetFillStyle(1,Col);
   FloodFill(X2+1, Y2+1, GetMaxColor);
   SetFillStyle(1,Mcol);
   FloodFill(X2 - 3, Y2 - 3, GetMaxColor);
   SetColor(0);
   Rectangle(X1, Y1, X2, Y2);
   SetColor(15);
   Line(X1,Y1,X2,Y1);
   Line(X2,Y2,X2,Y1);
   SetColor(0);
   Line(X1-Hef,Y1+Hef,X2-Hef,Y1+Hef);
   Line(X1+Hef,Y1+Hef,X2+Hef,Y1+Hef);
   Line(X2-Hef,Y2-Hef,X2-Hef,Y1+Hef);
end;
Procedure Load_Pic_Grp(X,Y,X1,Y1,C0:integer;File_Name:String);
var
  P:Pic;
  F:File of Pic;
  I,J:integer;
Begin
   if X1 > 79 then X1 := 79;
   if Y1 > 49 then Y1 := 49;
   Assign(F,File_Name);
   Reset(F);
   Read(F,P);
   if IOResult <> 0 then Exit;
   Close(F);
   for I := 1 to Y1 do for J := 1 to X1 do
   Begin
      if C0 <> 1 then
        if P.BkColor[I,J] <> 0 then PutPixel(J+X,I+Y,P.BkColor[I,J]);
      if C0 = 1 then
        if P.BkColor[I,J] <> 0 then PutPixel(J+X,I+Y,0);
   End;
End;
Procedure InText(var R:String;Max,Color,BColor:integer);
var
 S, X, Y, I:integer;
 Ch : Char;
 Het:Boolean;
Begin
   Het := False;
   X := GetX;
   Y := GetY;
   S := X;
   SetColor(Color);
   MoveTo(X,Y);
   OutText('');
   MoveTo(X,Y);
   if Length(R) <= Max then for I := 1 to Length(R) do
   Begin
      SetColor(0);
      OutText('');
      SetColor(Color);
      MoveTo(GetX-8,Y);
      OutText(R[I]);
      OutText('');
      MoveTo(GetX-8,Y);
      X := X + 1;
   End
  else R := '';
   Repeat
      Ch := ReadKey;
      if Ch = #0 then
      Begin
         Ch := ReadKey;
         Ch := ' ';
         Het := True;
      End;
      if (Ch<>#8)and(X<Max+S)and(Ch<>Enter_Key)and(Ch<>Esc_Key)and(Not Het)then
      Begin
         SetColor(0);
         OutText('');
         SetColor(Color);
         MoveTo(GetX-8,Y);
         OutText(Ch);
         OutText('');
         MoveTo(GetX-8,Y);
         X := X + 1;
         R := R + Ch;
      End;
      if (Ch = #8) and (X > S) then
      Begin
         X := X - 1;
         MoveTo(GetX-8,Y);
         SetColor(BColor);
         OutText('');
         SetColor(Color);
         MoveTo(GetX-8,Y);
         OutText('');
         SetColor(BColor);
         OutText('');
         SetColor(Color);
         MoveTo(GetX-16,Y);
         Delete(R,Length(R),1);
      End;
      Het := False;
   until (Ch = Esc_Key) or (Ch = Enter_Key);
   SetColor(BColor);
   OutText('');
   SetColor(Color);
   if Ch <> Enter_Key then R := '';
End;

Procedure OutTextLn(S:String);
var
 X,Y:integer;
Begin
   X := GetX;
   Y := GetY+TextHeight(S);
   OutText(S);
   MoveTo(X,Y);
End;
Procedure GrpView(FileName,Asc:String);
var
 F:Text;
 Ln:String;
 Done,S: Boolean;
Begin
   Assign(F,FileName);
   if Asc = 'no' then
   Begin
      Reset(F);
      While Not Eof(F) do
      Begin
         Readln(F,Ln);
         OutTextLn(Ln);
      End;
   End
  else
   Begin
      S := False;
      Done := False;
      Reset(F);
      While Not Done do
      Begin
         Readln(F,Ln);
         if (S)and(Ln <> Asc) Then OutTextLn(Ln);
         if (S) and (Ln = Asc) then Done := True;
         if Ln = Asc then S := True;
         if Eof(F) then Done := True;
      End;
   End;
End;
Procedure GrpScroll.Init(Hef, PMax, CC,B,S:integer; PFName : String);
var
 II, BtnY : Integer;
Begin
   Col := CC;
   BCol := B;
   SCol := S;
   FileName := PFName;
   H := Hef;
   C := 1;
   Max := PMax;
   X1 := GetX;
   Y1 := GetY;
   X2 := X1 + Hef;
   Y2 := Y1 + 9;
   SX := X1;
   SY := Y1;
   for II := 0 to Max-1 do
   Begin
      BtnY := Y1 + II * 11;
      with Buttons[II+1] do
      Begin
         Y := BtnY;
         Y1 := Y + 9;
         ID := II+1;
      End;
      Buttons[II+1].X := X1;
      Buttons[II+1].X1 := X1 + Hef;
   End;
   RoundBtn.X := X1 - 1;
   RoundBtn.Y := Y1 - 1;
   RoundBtn.X1 := X2 + 1;
   RoundBtn.Y1 := Y1 + Max * (TextHeight('')+3);
   UpB.X := RoundBtn.X1+1;
   UpB.Y := RoundBtn.Y;
   UpB.X1 := RoundBtn.X1+ 31;
   UpB.Y1 := RoundBtn.Y+ 23;

   DnB.X := RoundBtn.X1+1;
   DnB.Y := RoundBtn.Y1-23;
   DnB.X1 := RoundBtn.X1+ 31;
   DnB.Y1 := RoundBtn.Y1;
   SetFillStyle(1,BCol);
   With RoundBtn do
   Begin
      Bar(X,Y,X1,Y1);
   End;
   ButtonRect(UpB);
   ButtonRect(DnB);
   With RoundBtn do
   Begin
      X1 := DnB.X1;
   End;
   ButtonRect(RoundBtn);
   Line(UpB.X, UpB.Y1, (UpB.X+14), UpB.Y);
   Line((UpB.X+14), UpB.Y,UpB.X1, UpB.Y1);

   Line(DnB.X,DnB.Y, (DnB.X+14), DnB.Y1);
   Line((DnB.X+14), DnB.Y1,DnB.X1, DnB.Y);

   Line(UpB.X, UpB.Y1, DnB.X, DnB.Y);
   Line(UpB.X1, UpB.Y1, DnB.X1, DnB.Y);

   From_P := 1;
   To_P := From_P + Max;
   ReadFile;
   Drow(1);
End;
Procedure GrpScroll.Drow(AA:integer);
var
 W,J:integer;
Begin
   HideMouse;
   if AA = 1 then
   Begin
      MoveTo(SX+5,SY+1);
      SetColor(Col);
      For W := 1 to Max do
      Begin
         OutText(List[W]);
         MoveTo(SX+5,GetY+11);
      End;
   End;
   if AA = 2 then
   Begin
      MoveTo(SX+5,SY+1);
      SetColor(BCol);
      For W := 1 to Max do
      Begin
         OutText(List[W]);
         MoveTo(SX+5,GetY+11);
      End;
   End;
   ShowMouse;
End;
Procedure GrpScroll.ReadFile;
var
 A:String;
 F:Text;
 II:integer;
Begin
   EOFile := False;
   Assign(F,FileName);
   Reset(F);
   for II := 1 to From_P-1 do Readln(F,A);
   A := '';
   for II := 1 to Max do
   Begin
      Readln(F,List[II]);
      if Eof(F) then Max := II;
      if Eof(F) then EOFile := True;
      if Eof(F) Then Break;
   End;
   Close(F);
End;
Procedure GrpScroll.MoveSaman(A:integer);
Begin
   HideMouse;
   SetColor(BCol);
   Rectangle(X1, Y1, X2, Y2);
   SetColor(SCol);
   if (A = 1) then
   Begin
      if (C=Max) then MoveScroll(1)
      else
      Begin
         Y1 := Y1 + 11;
         Y2 := Y2 + 11;
         C := C + 1;
      End;
   End;
   if A = 2 then
   Begin
      if (C = 1) then MoveScroll(2)
      else
      Begin
         Y1 := Y1 - 11;
         Y2 := Y2 - 11;
         C := C - 1;
      End;
   End;
   SetColor(SCol);
   Rectangle(X1, Y1, X2, Y2);
   ShowMouse;
End;
Procedure GrpScroll.MoveScroll(A:integer);
Begin
   HideMouse;
   if (A = 1) and (Not EOFile)then
   Begin
      Drow(2);
      From_P := From_P+1;
      To_P := From_P+Max;
      ReadFile;
      Drow(1);
   End;
   if (A = 2) and (From_P>1)then
   Begin
      Drow(2);
      From_P := From_P-1;
      To_P := From_P-Max;
      ReadFile;
      Drow(1);
   End;
   ShowMouse;
End;
Procedure GrpScroll.Menu;
var
  Ch:Char;
  II : Integer;
  J  : Integer;
begin
  SetColor(SCol);
  Rectangle(X1,Y1,X2,Y2);
  Repeat
     if KeyPressed then
     Begin
        Ch := ReadKey;
        if Ch = #0 then
        Begin
           Ch := ReadKey;
           if (Ch = Down_Key) Then MoveSaman(1);
           if (Ch = Up_Key) then MoveSaman(2);
        End;
        if Ch = Enter_Key then Ok := True;
     End;
     if (ButtonDown) and (ChekButton(UpB, GetMGX, GetMGY)) then
     Begin
        MoveScroll(2);
        DelayT(2);
     End;
     if (ButtonDown) and (ChekButton(DnB, GetMGX, GetMGY)) then
     Begin
        MoveScroll(1);
        DelayT(2);
     End;
     if ButtonDown then
      if ChekButton(RoundBtn, GetMGX, GetMGY) then
     Begin
        for II := 1 to Max do
        Begin
           if ChekButton(Buttons[II], GetMGX, GetMGY) then
           Begin
              Repeat Until ButtonUp;
              if (C <> Buttons[II].ID) then
              Begin
                 HideMouse;
                 SetColor(BCol);
                 Rectangle(X1,Y1,X2,Y2);
                 C := Buttons[II].ID;
                 Y1 := Sy + ((C-1)*11);
                 Y2 := Y1 + 9;
                 SetColor(SCol);
                 Rectangle(X1,Y1,X2,Y2);
                 ShowMouse;
                 Break;
              End
             else
              Begin
                 Ch := Enter_Key;
                 Ok := True;
              End;
           End;
        End;
     End
    else
      Begin
         Ch := Enter_Key;
         Ok := False;
      End;

  until (Ch = Enter_Key);
  if Ok then Repeat Until ButtonUp;
  Result := List[C];
  SetColor(BCol);
  Rectangle(X1,Y1,X2,Y2);
  SetColor(Col);
end;
Procedure InitGDriver;
var
 GError : Integer;
 Dir : String;
Begin
   GetDir(0,Dir);
   InitGraph(GDriver, GMode, '');
   GError := GraphResult;
   While GError <> 0 do
   Begin
      Writeln('Graphics Error: ',GraphErrorMsg(GError));
      Writeln('Enter the full path of your BGI driver (Ctrl+Break Aborts):');
      Readln(Dir);
      GDriver := Detect;
      InitGraph(GDriver, GMode, Dir);
      GError := GraphResult;
   End;
End;
Procedure Ln(Kir:Boolean);
Begin
   if Kir then MoveTo(0, GetY+TextHeight(''))
   else MoveTo(GetX, GetY+TextHeight(''));
End;

Procedure GRead(var S:String;Max:Byte);
var
 Slx,
 Sly      : Integer;
 C, Hef   : Integer;
 Tmp      : String;
 Done     : Boolean;
 Ch       : Char;
 SvColor  : Integer;

Function OK : Boolean;
Begin
   OK := False;
   if (Ch <> Enter_Key) and
      (Ch <> #0) and
      (Ch <> BackSpace) and
      (Done = False) then
       OK := True;
End;

Function OK2 : Boolean;
Begin
   OK2 := False;
   if (C > 0) and
      (Done = False) then
       OK2 := True;
End;

Function OK3: Boolean;
Begin
   OK3 := False;
   if (C < Max) and
      (Done = False) then
       OK3 := True;
End;

Procedure DrawLine;
var
 Sx, Sy:Integer;
Begin
   Sx := GetX;
   Sy := GetY;
   OutText(#179);
   MoveTo(Sx, Sy);
End;

Procedure ChrCheck;
Begin
   if Ch = #0 then
   Begin
      Ch := ReadKey;
      Ch := #0;
   End;
   if Ch = Esc_Key then Ch := #0;
End;

Begin
   Tmp := '';
   Done := False;
   C := 0;
   Sly := 0;
   Slx := 0;
   SetTextStyle(DefaultFont, HorizDir, 1);
   if S <> '' then
   for C := 1 to Length(S) do
   Begin
      Slx := GetX;
      Sly := GetY;
      SvColor := GetColor;
      SetColor(GetBkColor);
      DrawLine;
      SetColor(SvColor);
      OutText(S[C]);
      DrawLine;
      Hef := TextWidth(S[C]);
      Tmp := S;
   End
  else DrawLine;
   Repeat
       Ch := ReadKey;
       ChrCheck;
       if Ch = Enter_Key then Done := True;
       if (OK) and (OK3) then
       Begin
          Inc(C);
          Slx := GetX;
          Sly := GetY;
          SvColor := GetColor;
          SetColor(GetBkColor);
          DrawLine;
          SetColor(SvColor);
          OutText(Ch);
          DrawLine;
          Hef := TextWidth(Ch);
          Tmp := Tmp + Ch;
       End;
       if (Ch = BackSpace) and (OK2) then
       Begin
          C := C - 1;
          SvColor := GetColor;
          SetColor(GetBkColor);
          DrawLine;
          MoveTo(Slx, Sly);
          OutText('');
          MoveTo(Slx, Sly);
          SetColor(SvColor);
          DrawLine;
          Slx := Slx - Hef;
          Delete(Tmp, Length(Tmp), 1);
       End;

   Until Done;
   SvColor := GetColor;
   SetColor(GetBkColor);
   DrawLine;
   SetColor(SvColor);
   S := Tmp;
End;

Procedure WinGrp.Init(PX, PY, PX1, PY1, PFill, PTfill,
                      PTC:Integer;PTitle:String);
Begin
   X := PX;
   Y := PY;
   X1 := PX1;
   Y1 := PY1;
   Title := PTitle;
   Fill := PFill;
   TFill := PTFill;
   TC := PTC;
   CloseButton.X := X+1;
   CloseButton.Y := Y+1;
   CloseButton.X1 := X+20;
   CloseButton.Y1 := Y+19;
   CloseButton.Name := 'X';
End;

Procedure WinGrp.Disp;
var
 SvColor : Byte;
Begin
   HideMouse;
   if Saving then
   Begin
      Size := ImageSize(X-3, Y-3, X1+3, Y1+3);
      if Size > 65519 then
      Begin
         CloseGraph;
         Writeln('Error: Window to large to accept to the memory.');
         Halt;
      End;
      GetMem(P, Size);
      GetImage(X-3, Y-3, X1+3, Y1+3, P^);
   End;
   SvColor := GetColor;
   SetFillStyle(1, Fill);
   Bar(X, Y, X1, Y1);
   SetFillStyle(1, TFill);
   Bar(X, Y, X1, Y+20);
   SetFillStyle(1, 15);
   {----- Draw "-" ------------}
   Bar(X+1, Y+1, X+20, Y+19);
   Line(X+5, Y+9, X+17, Y+9);
   Line(X+5, Y+10, X+17, Y+10);
   SetColor(7);
   Line(X+4, Y+11, X+16, Y+11);
   PutPixel(X+4, Y+10, 7);
   {----- Draw "-"(End) -------}
   SetColor(SvColor);
   Rectangle(X, Y, X1, Y1);
   Line(X, Y+20, X1, Y+20);
   MoveTo(((X1+X) div 2) - ((Length(Title)*TextHeight('')) div 2), Y+6);
   SetColor(TC);
   OutText(Title);
   SetColor(SvColor);
   ShowMouse;
End;
Procedure WinGrp.Erase;
Begin
   HideMouse;
   if Saving then
   Begin
      PutImage(X-3, Y-3, P^, NormalPut);
      FreeMem(P, Size);
   End;
   ShowMouse;
End;

Procedure WinGrp.Move_Win;
var
 Ch : Char;
 D, C : Boolean;
 HefX, HefY : Integer;
Begin
   D := False;
   HefX := X1 - X;
   HefY := Y1 - Y;
   HideMouse;
   C := True;
   Disp;
   Repeat
      {Ch := ReadKey;
      if Ch = #0 then
      Begin
         Ch := ReadKey;}
       {  if C then Disp;
         {---------------------------------------------------------}
        { if (GetMGX > X) and (X1 < GetMaxX - 8) then X := GetMGX;
         if (GetMGX < X) and (X > 5) then X := GetMGX;
         if (GetMGY < Y) and (Y > 5) then Y := GetMGY;
         if (GetMGY > Y) and (Y1 < GetMaxY - 4) then Y := GetMGY;
         {---------------------------------------------------------}
        { X1 := X + HefX;
         Y1 := Y + HefY;
         C := False;
         if (GetMGX <> X) or (GetMGY <> Y) then
         Begin
            Erase;
            C := True;
         End;                        }
      if (X <> GetMGX) or (Y <> GetMGY) then
      Begin
         Erase;
         X := GetMGX;
         Y := GetMGY;
         if X < 5 then X := 5;
         if Y < 5 then Y := 5;
         if Y > GetMaxY-10 then Y := GetMaxY - 10;
         if X > GetMaxX-(HefX+5) then X := GetMaxX-(HefX+5);
         X1 := X + HefX;
         Y1 := Y + HefY;
         Disp;
      End;
      if ButtonDown then D := True;
   Until D;
   CloseButton.X := X+1;
   CloseButton.Y := Y+1;
   CloseButton.X1 := X+20;
   CloseButton.Y1 := Y+19;
   CloseButton.Name := 'X';

   ShowMouse;
End;

Function ChekButton(B : Button; X, Y : Integer):Boolean;
Begin
   ChekButton := False;
   if (X >= B.X) and (X <= B.X1) then
    if (Y >= B.Y) and (Y <= B.Y1) then
     ChekButton := True;
End;

Procedure Draw_WButton(B : Button; BColor : Byte ;Mesuman : Boolean2);
var
 Pic : Boolean;
Begin
    Pic := False;
    if B.PicFName <> '' then
     if Exist(B.PicFName) then
       Pic := True;
    if Mesuman <> Pushed then
    Begin
       SetFillStyle(1,0);
       Bar(B.X+2,B.Y+4, B.X1+2,B.Y1+4);
       SetFillStyle(1, B.Color);
       Bar(B.X, B.Y, B.X1, B.Y1);
       if Pic then Load_Pic_Grp(B.X,B.Y,B.X1-B.X,B.Y1-B.Y,0,B.PicFName);
       SetColor(0);
       Rectangle(B.X, B.Y, B.X1, B.Y1);
       SetColor(15);
       OutTextXY(B.X+10, B.Y+10, B.Name);
    End
   else
    Begin
       SetFillStyle(1,BColor);
       Bar(B.X, B.Y, B.X1, B.Y1);
       SetFillStyle(1,B.Color);
       Bar(B.X+2,B.Y+4, B.X1+2,B.Y1+4);
       SetColor(0);
       Rectangle(B.X+2, B.Y+4, B.X1+2, B.Y1+4);
       SetColor(15);
       OutTextXY(B.X+12, B.Y+14, B.Name);
    End;
End;

Procedure Draw_Button(B : Button; BColor : Byte ;Mesuman : Boolean2);
var
 Pic : Boolean;
Begin
    Pic := False;
    if B.PicFName <> '' then
     if Exist(B.PicFName) then
       Pic := True;
    if Mesuman <> Pushed then
    Begin
       SetFillStyle(1, B.Color);
       Bar(B.X, B.Y, B.X1, B.Y1);
       if Pic then Load_Pic_Grp(B.X,B.Y,B.X1-B.X,B.Y1-B.Y,0,B.PicFName);
       SetColor(0);
       Rectangle(B.X, B.Y, B.X1, B.Y1);
       Rectangle(B.X, B.Y, B.X1+1,B.Y1+1);
       SetColor(BTC);
       OutTextXY(B.X+10, B.Y+9, B.Name);
    End
   else
    Begin
       SetFillStyle(1,B.Color);
       Bar(B.X+1,B.Y+1,B.X1+1,B.Y1+1);
       SetColor(0);
       Rectangle(B.X+1, B.Y+1, B.X1+1, B.Y1+1);
       if B.Color <> BColor then
         SetColor(B.Color)
        else
         SetColor(15);
       Rectangle(B.X, B.Y, B.X1, B.Y1);
       Rectangle(B.X, B.Y, B.X1+1,B.Y1+1);
       SetColor(BTC);
       OutTextXY(B.X+11, B.Y+10, B.Name);
    End;
End;

Function PressButton(B : Button;BColor : Byte) : Boolean;
Begin
   HideMouse;
   Draw_Button(B,BColor, Pushed);
   ShowMouse;
   Repeat Until ButtonUp;
   HideMouse;
   Draw_Button(B,BColor, t);
   if (ChekButton(B, GetMGX, GetMGY)) then
      PressButton := True
    else
      PressButton := False;
End;


Procedure Dialog.Init(var PW : WinGrp);
Begin
   Randomize;
   Count := 0;
   W := PW;
   ShowMouse;
   HideMouse;
   PW.Disp;
   ShowMouse;
   BColor := PW.Fill;
End;
Procedure Dialog.Add_Button(X, Y : Integer; Name : String;ID : Integer);
var
 RColor : Byte;
Begin
   Inc(Count);
   Buttons[Count].X := X;
   Buttons[Count].Y := Y;
   Buttons[Count].X1 := X+Length(Name)*(TextHeight(''))+20;
   Buttons[Count].Y1 := Y + 20;
   Buttons[Count].Name := Name;
   Buttons[Count].ID := ID;
   Buttons[Count].PicFName := '';
 {  Repeat
      RColor := Random(13)+1;
   Until RColor <> 11;   }
   Buttons[Count].Color := 7;
End;
Procedure Dialog.Disp_Buttons;
var
 I:Byte;
Begin
   HideMouse;
   for I := 1 to Count do
     Draw_Button(Buttons[I],BColor, T);
   ShowMouse;
End;
Procedure Dialog.Play;
var
 Saman, I : Byte;
 Done : Boolean;
Begin
   Done := False;
   Disp_Buttons;
   Repeat
       if (ButtonDown) then
       Begin
          for I := 1 to Count do
           if ((ChekButton(Buttons[I], GetMGX, GetMGY))) and (ButtonDown) then
           Begin
              R2 := Buttons[I];
              if PressButton(R2,BColor) then
              Begin
                 Done := True;
                 Result := R2.ID;
                 HideMouse;
                 ShowMouse;
              End
              else
                 ShowMouse;
           End;
       End;
       if (ChekButton(W.CloseButton, GetMGX, GetMGY)) and (ButtonDown) then
       Begin
          Result := ID_Exit;
          HideMouse;
          ShowMouse;
          Repeat Until ButtonUp;
          if ChekButton(W.CloseButton, GetMGX, GetMGY) then
          Begin
             HideMouse;
             Done := True;
          End;
       End;
    {   if PM.Result = Esc then
       Begin
          Result := ID_Exit;
          Exit;
       End;  }
   Until Done;
End;

Procedure DrawStatusLine;
Begin
   SetColor(GTextColor);
   Line(0,GetMaxY-TextHeight('')-5,GetMaxX,
          GetMaxY-TextHeight('')-5);
End;

Constructor GYApplication.Init;
var
 I : Byte;
Begin
   ExitApp := False;
   InitMainWindow;
   InitGDriver;
   SetGraphMode(VGAHi);
   InitMouse;
   SetColor(0);
   InitMainWindow;
   W.Disp;
   D.Init(W);
   InitButtons;
   InitQStr;
   InitOther;
   SetSColor(0,7);
End;

Procedure GYApplication.InitQStr;
Begin
   QuitStr := 'Do you want to quit?';
End;

Procedure GYApplication.InitMainWindow;
Begin
   W.Init(0,0,GetMaxX,GetMaxY,7,Blue,15,'Main Window');
End;

Procedure GYApplication.InitButtons;
Begin
   D.Add_Button(GetMaxX-70, GetMaxY-40, 'Exit',ID_Exit);
End;

Procedure ShowStatus(SStr : String);
Begin
   SetTextStyle(DefaultFont, HorizDir, 1);
   DrawStatusLine;
   MoveTo( (GetMaxX div 2)  - ((Length(LastStatus)*TextHeight('')) div 2),
               GetMaxY-TextHeight('')-2);

   SetColor(GBkColor);
   OutText(LastStatus);
   SetColor(GTextColor);

   MoveTo( (GetMaxX div 2)  - ((Length(SStr)*TextHeight('')) div 2),
               GetMaxY-TextHeight('')-2);

   OutText(SStr);
   LastStatus := SStr;
End;

Procedure GYApplication.Case_Procedure;
Begin
End;

Procedure GYApplication.StartUp;
Begin
End;

Procedure GYApplication.InitOther;
Begin
End;

Procedure GYApplication.Run;
var
 Don : Boolean;
Begin
   StartUp;
   Don := False;
   if ExitApp then Exit;
   Repeat
     ShowMouse;
     D.Play;
     ShowMouse;
     Case_Procedure;
     if (D.Result = ID_Exit)
     and(GQuestion(QuitStr,QTitle)) then Don := True;
   Until (Don) or (ExitApp);
End;

Procedure GYApplication.ExitApplication;
Begin
   ExitApp := True;
End;

Procedure GYApplication.Done;
Begin
   CloseGraph;
End;

Procedure GDispStr(S:String);
var
 P, Sx  : integer;
 SS : Boolean;
Begin
   SS := False;
   Sx := GetX;
   SetColor(Dc);
   for P := 1 to Length(S) do
   Begin
      if (S[P] <> '~') then
      Begin
         if ((S[P] <> '\')or(S[P+1] <> 'n'))then OutText(S[P]);
      End
     else if not SS then
      Begin
         SS := True;
         SetColor(DispSColor);
      End
     else
      Begin
         SS := False;
         SetColor(Dc);
      End;
      if (S[P] = '\') and (S[P+1] = 'n') then
      Begin
         MoveTo(Sx, GetY);
         Ln(False);
         Inc(P);
      End;
   End;
End;

Function GQuestion(Msg, Title : String) : Boolean;
var
 L, I : Byte;
 Lns : Byte;
 X, Y, X1, Y1 : Integer;
 WW : WinGrp;
 D : Dialog;
 SDc, SDsc : Byte;
Begin
   SDc := Dc;
   SDsc := DispSColor;
   for L := 1 to Length(Msg) do
    if (Msg[L] = '\') and (Msg[L+1] = 'n') then Break;
   L := L + 4;
   Lns := 0;
   for I := 1 to Length(Msg) do
    if (Msg[I] = '\') and (Msg[I+1] = 'n') then Inc(Lns);
   Lns := Lns + 4;
   X := (GetMaxX div 2) - ((L*TextHeight('')+10) div 2);
   Y := (GetMaxY div 2) - ((Lns*TextHeight('')+70) div 2);
   X1 := X + L*TextHeight('')+10;
   Y1 := Y + Lns*TextHeight('')+70;
   WW.Saving := True;
   WW.Init(X, Y, X1, Y1, 15, Blue, 15, Title);
   SetColor(0);
   D.Init(WW);
   D.Add_Button(X+10, Y1-40, Yes, ID_Ok);
   D.Add_Button(X1-30-Length(No)*TextHeight(''), Y1-40, No,
                ID_Cancel);
   MoveTo(X+10,Y+30);
   HideMouse;
   GDispStr(Msg);
   ShowMouse;
   D.Play;
   if D.Result = ID_Ok then
   Begin
      SetSColor(7,7);
      MoveTo(X+10,Y+30);
      GDispStr(Msg);
      DelayT(10);
      SetSColor(SDc, SDsc);
      GQuestion := True;
   End
   else GQuestion := False;
   WW.Erase;
   ShowMouse;
End;

Procedure GMessage(Msg, Title : String);
var
 L, I : Byte;
 Lns : Byte;
 X, Y, X1, Y1 : Integer;
 WW : WinGrp;
 D : Dialog;
 SDc, SDsc : Byte;
Begin
   SDc := Dc;
   SDsc := DispSColor;
   for L := 1 to Length(Msg) do
    if (Msg[L] = '\') and (Msg[L+1] = 'n') then Break;
   L := L + 4;
   Lns := 0;
   for I := 1 to Length(Msg) do
    if (Msg[I] = '\') and (Msg[I+1] = 'n') then Inc(Lns);
   Lns := Lns + 4;
   X := (GetMaxX div 2) - ((L*TextHeight('')+10) div 2);
   Y := (GetMaxY div 2) - ((Lns*TextHeight('')+70) div 2);
   X1 := X + L*TextHeight('')+10;
   Y1 := Y + Lns*TextHeight('')+70;
   WW.Saving := True;
   WW.Init(X, Y, X1, Y1, 15, Blue, 15, Title);
   SetColor(0);
   D.Init(WW);
   D.Add_Button( (X+(X1-X) div 2)-((Length(Ok)*TextHeight('')div 2)+20 ),
                    Y1-40, Ok, ID_Ok);
   MoveTo(X+10,Y+30);
   HideMouse;
   GDispStr(Msg);
   ShowMouse;
   D.Play;
   SetSColor(7,7);
   MoveTo(X+10,Y+30);
   GDispStr(Msg);
   DelayT(10);
   SetSColor(SDc, SDsc);
   WW.Erase;
   ShowMouse;
End;

Procedure InitYesNo(Y, N:String);
Begin
   SvYes := Yes;
   SvNo := No;
   Yes := Y;
   No := N;
End;

Procedure ReturnYesNo;
Begin
   Yes := SvYes;
   No := SvNo;
End;

Procedure Page2.Init(FN : String; Col, BCol : Byte; M : Integer);
Begin
   FName := FN;
   Color := Col;
   Max := M;
   Sx := GetX;
   Sy := GetY;
   BColor := BCol;
   FromP := 1;
   ToP := FromP + Max;

End;

Procedure Page2.Read_Page(N : Boolean);
var
 F : Text;
 I : Integer;
 Z : String;
Begin
   HideMouse;
   Count := Max;
   MoveTo(Sx,Sy);
   if N Then SetColor(BColor);
   Assign(F, FName);
   Reset(F);
   if FromP > 1 then for I := 1 to FromP-1 do Readln(F, Z);
   for I := 1 to Max do
   Begin
      Readln(F, Z);
      OutText(Z);
      MoveTo(Sx, GetY+TextHeight(''));
      if eof(F) then
      Begin
         Count := I;
         Break;
      End;
   End;
   Close(F);
   SetColor(Color);
   ShowMouse;
End;

Procedure Page2.Display;
var
 Ch : Char;
Begin
   MoveTo(Sx,Sy);
   SetColor(Color);
   Read_Page(False);
   Repeat
     if KeyPressed then
     Begin
        Read_Page(False);
        Ch := ReadKey;
        if Ch = PgDn_Key then
        Begin
           if Count = Max then
           Begin
              Read_Page(True);
              FromP := FromP + Max;
              ToP := FromP + Max;
              Read_Page(False);
           End;
        End;
        if (Ch = PgUp_Key) and (FromP > 1) then
        Begin
           Read_Page(True);
           FromP := FromP - Max;
           ToP := FromP - Max;
           Read_Page(False);
        End;
        if Ch = Down_Key then
        Begin
           if Count = Max then
           Begin
              Read_Page(True);
              FromP := FromP + 1;
              ToP := FromP + Max;
              Read_Page(False);
           End;
        End;
        if (Ch = Up_Key) and (FromP > 1) then
        Begin
           Read_Page(True);
           FromP := FromP - 1;
           ToP := FromP - Max;
           Read_Page(False);
        End;
     End;
     if ButtonDown then Ch := Enter_Key;
   until (Ch = Enter_Key) or (Ch = Esc_Key);
   SetColor(Color);
End;

Procedure Register_BGI_Driver;
Begin
   if RegisterBGIDriver(@CGADriverProc) < 0 then
      Halt;
   if RegisterBGIDriver(@EGAVGADriverProc) < 0 then
      Halt;
   if RegisterBGIDriver(@HercDriverProc) < 0 then
      Halt;
   if RegisterBGIDriver(@ATTDriverProc) < 0 then
      Halt;
   if RegisterBGIDriver(@PC3270DriverProc) < 0 then
      Halt;

   if RegisterBGIFont(@TriplexFontProc) < 0 then
      Halt;
   if RegisterBGIFont(@SmallFontProc) < 0 then
      Halt;
   if RegisterBGIFont(@SansSerifFontProc) < 0 then
      Halt;
   if RegisterBGIFont(@GothicFontProc) < 0 then
      Halt;
End;

Function GetMGX;
Begin
   GetMGX := GetMouseX * 2;
End;

Function GetMGY;
Begin
   GetMGY := GetMouseY;
End;

Procedure ButtonRect(B:Button);
Begin
   Rectangle(B.X, B.Y, B.X1, B.Y1);
End;

Procedure Disp(S : String);
var
 I   : Integer;
 SvX, SvX2, SColor : Byte;
Begin
   SvX := GetX;
   SColor := GetColor;
   for I := 1 to Length(S) do
   Begin
      SetColor(15);
      OutText(S[I]);
      beep(900,50,50);
      MoveTo(GetX-TextWidth(S[I]), GetY);
      SetColor(SColor);
      OutText(S[I]);
   End;
   MoveTo(SvX, GetY+TextHeight(S));
End;

Procedure Rectangle(X,Y,X1,Y1 : Integer);
Begin
   Graph.Rectangle(X,Y,X1,Y1);
End;

Procedure Circle(X,Y,Ratio : Integer);
Begin
   Graph.Circle(X,Y,Ratio);
End;

Procedure PutPixel(X,Y,Color : Integer);
Begin
   Graph.PutPixel(X,Y,Color);
End;

Procedure Bar3D(x1, y1, x2, y2: Integer; Depth: Word; Top: Boolean);
Begin
   Graph.Bar3D(x1,y1,x2,y2,Depth,Top);
End;

Procedure Bar(X,Y,X1,Y1 : Integer);
Begin
   Graph.Bar(X,Y,X1,Y1);
End;

Procedure Line(X,Y,X1,Y1 : Integer);
Begin
   Graph.Line(X,Y,X1,Y1);
End;

Procedure LineTo(X,Y : Integer);
Begin
   Graph.LineTo(X,Y);
End;

Procedure SetFillStyle(I1, I2 : Byte);
Begin
  Graph.SetFillStyle(I1,I2);
End;

Procedure FloodFill(X,Y,MC : Integer);
Begin
   Graph.FloodFill(X,Y,MC);
End;

Procedure SetFont(Font, Godel : Integer);
Begin
   Graph.SetTextStyle(Font, HorizDir, Godel);
End;

Procedure CloseGraph;
Begin
   Graph.CloseGraph;
End;

Procedure GPic.Load(FName : String; PNum : Integer);
var
 F : file of pic;
Begin
   Error := 0;
   if not Exist(FName) then
   Begin
      Error := 1;
      Exit;
   End;
   Assign(F, FName);
   Reset(F);
   {$I-}Seek(F,PNum-1);{ $I+}
   if IOResult <> 0 then
   Begin
      Error := 2;
      Exit;
   End;
   {$I-}Read(F, P);{$I+}
   if IOResult <> 0 then
   Begin
      Error := 3;
      Exit;
   End;
   Close(F);
End;

Procedure GPic.Load_Mem(Pic_Data : Pointer);
var
 PP : ^Pic;
Begin
   PP := @Pic_Data^;
   P  := PP^;
End;


Procedure GPic.Disp(PX, PY, PX1, PY1: Integer);
var
 I, J : Integer;
Begin
   PicBtn.X := Px;
   PicBtn.Y := Py;
   PicBtn.X1 := Px+Px1;
   PicBtn.Y1 := Py+Py1;
   X := Px;
   Y := Py;
   X1:= Px1;
   Y1:= Py1;
   Size := ImageSize(X, Y, X+X1, Y+Y1);
   GetMem(Image, Size);
   GetImage(X,Y,X+X1,Y+Y1,Image^);
   if Error > 0 then Exit;
   if X1 > 79 then X1 := 79;
   if Y1 > 49 then Y1 := 49;
   for I := 1 to Y1 do for J := 1 to X1 do
   Begin
      if P.BkColor[I,J] <> 0 then PutPixel(J+X,I+Y,P.BkColor[I,J]);
   End;
End;

Procedure GPic.DispFullScr;
var
 PX, PY : Integer;
Begin
   PX := 0; PY := 0;
   Disp(PX, PY, 80, 50);
   Repeat
       Repeat
           PY := PY + 50;
           Disp(PX, PY, 80, 50);
       Until Y >= GetMaxY;
       PY := 0;
       PX := PX + 80;
       Disp(PX,PY,80,50);
   Until PX >= GetMaxX;
End;

Procedure GPic.Erase;
Begin
   PutImage(X,Y,Image^, NormalPut);
   FreeMem(Image, Size);
End;


Procedure ShowError(Num : Integer);
Begin
   if Num > NumErrors then Exit;
   if Num = 0 then Exit;
   InitGDriver;
   InitMouse;
   ShowMouse;
   SetSColor(0, 7);
   GMessage('                                      \n'+
            Errors[Num], 'GrpTools Runtime Error');

End;

Procedure FlyText(Text : String; Y : Integer);
var
 X : Integer;
 P : Pointer;
 Size : Word;
Begin
   SetColor(15);
   for X := 0-TextWidth(Text) to GetMaxX do
   Begin
      SetSColor(15,7);
  {    Size := ImageSize(X,Y,TextWidth(Text),TextHeight(Text));
      GetMem(P, Size);
      GetImage(X,Y,TextWidth(Text),TextHeight(Text),P^);}
      MoveTo(X, Y);
      GDispStr(Text);
      Delay(10);
     { PutImage(X,Y,P^,NormalPut);
      FreeMem(P, Size);}
      SetSColor(0,7);
      MoveTo(X, Y);
      GDispStr(Text);

   End;
End;

Function TPressButton(B : Button) : Boolean;
Begin
   Repeat Until ButtonUp;
   if (ChekButton(B, GetMGX, GetMGY)) then
      TPressButton := True
    else
      TPressButton := False;
End;

Procedure TEdit.Init(PS : String; PBCol, PMax: Byte;X,Y : Integer);
Begin
   BColor := PBCol;
   Sx := X;
   Sy := Y;
   Color := GetColor;
   S := PS;
   Max := PMax;
   Btn.X := Sx-6;
   Btn.Y := Sy-7;
   Btn.X1 := Sx+(Max*TextHeight(S))+7;
   Btn.Y1 := Sy+14;
End;

Procedure TEdit.DrawBox;
Begin
   HideMouse;
   MoveTo(Sx-6,Sy);
   SetColor(BColor);
   SetColor(15);
   Rectangle(Sx-6, Sy-7, Sx+Max*TextHeight(S)+7, Sy+14);
   Rectangle(Sx-6, Sy-7, Sx+Max*TextHeight(S)+7, Sy+15);
   SetFillStyle(1,BColor);
   Bar(Sx-5,Sy-6,Sx+Max*TextHeight(S)+6,Sy+13);
   SetColor(7);
   Line(Sx-6, Sy-7, Sx+Max*TextHeight(S)+7, Sy-7);
   Line(Sx-6, Sy+14, Sx-6,Sy-6);
   SvS := S;
   MoveTo(Sx,Sy);
   SetColor(Color);
   SLen  := Length(S);
   SamanPos := 200;
   DispLine(False);
   ShowMouse;
End;

procedure TEdit.DrawSaman;
begin
   Line(GetX, GetY-5, GetX, GetY+5+TextHeight(S));
end;


procedure TEdit.DispLine(E : Boolean);
var
 II : Integer;
begin
   HideMouse;
   MoveTo(Sx, Sy);
   if E then SetColor(BColor)
  else SetColor(Color);
   for II := 0 to SLen do
   Begin
      if (SamanPos = II) then DrawSaman;
      if (II > 0) and (SLen <> 0) then
      Begin
         if not Pass then OutText(S[II])
        else
         OutText('*');
      End;
   End;
   if SamanPos = SLen + 1 then DrawSaman;
   ShowMouse;
end;



Procedure TEdit.Edit;

Begin
   DispLine(True);
   SamanPos := SLen+1;
   DispLine(False);
   Done := False;
   Repeat
      if KeyPressed then
      Begin
         Ch := ReadKey;
         if Ch <> #0 then
         Begin
            if Ch = Enter_Key then
            Begin
               DispLine(True);
               SamanPos := 200;
               DispLine(False);
               Result := Enter;
               Exit;
            End;

            if Ch = Esc_Key then
            Begin
               DispLine(True);
               SamanPos := 200;
               DispLine(False);
               Result := Esc;
               Exit;
            End;

            if (Ch = Backspace) and (SamanPos > 1) and (SLen > 0) then
            Begin
               DispLine(True);
               Delete(S, SamanPos-1, 1);
               SamanPos := SamanPos - 1;
               SLen := Length(S);
               DispLine(False);
            End
           else if (SLen < Max) and (Ch <> Backspace)  then
            Begin
               DispLine(True);
               Insert(Ch, S, SamanPos);
               SamanPos := SamanPos + 1;
               SLen := Length(S);
               DispLine(False);
            End;
         End
        else {if Ch = #0}
         Begin
            Ch := ReadKey;
            DispLine(True);
            if (Ch = #83) and (SLen > 0) and (SamanPos <= Max) then
            Begin
               DispLine(True);
               Delete(S, SamanPos, 1);
               SLen := Length(S);
               DispLine(False);
            End;
            if (Ch = #8) then
            Begin
               S := SvS;
               SLen := Length(S);
               SamanPos := SLen+1;
            End;

            if (Ch = #71) then SamanPos := 1;

            if (Ch = #79) and (SLen > 0) then SamanPos := SLen+1;

            if (Ch = Left_Key) and (SamanPos > 1) then
              SamanPos := SamanPos - 1;
            if (Ch = Right_Key) and (SamanPos <= SLen) then
              SamanPos := SamanPos + 1;
            DispLine(False);
         End;
      End;
      if ButtonDown then
      Begin
         Done := True;
         Result := ButtonD;
      End;
   Until Done;
   DispLine(True);
   SamanPos := 200;
   DispLine(False);
End;

Function GOpenDialog(What : String) : String;
var
 Files  : GrpScroll;
 Dirs   : GrpScroll;
 BColor : Byte;
 Color  : Byte;
 W      : WinGrp;
 E1, E2 : TEdit;
 E3     : TEdit;
 Ok     : Button;
 Cancel : Button;
 FilesF : Text;
 DirsF  : Text;
 DirInfo: SearchRec;
 FF     : File;
 Attr   : Word;

Procedure FindFiles;
var
 W : WinGrp;
 DNum, FNum : Longint;
 LD, LF     : Longint;
Begin
   Assign(FilesF, 'C:\000.001');
   Assign(DirsF, 'C:\000.000');
   Rewrite(FilesF);
   Rewrite(DirsF);
   DNum := 0;
   FNum := 0;
   LD := 0;
   LF := 0;
   W.Saving := True;
   W.Init(100,90,300,160,15,Blue,15,'Scanning...');
   W.Disp;
   findfirst(What, anyfile, DirInfo);
   While DosError = 0 do
   Begin
      if (LD <> DNum) or (LF <> FNum) then
      Begin
         MoveTo(103,120);
         SetSColor(15,0);
         GDispStr('Files       :'+ClearNum(LF)+'\n'+
                  'Directories :'+ClearNum(LD));
         SetSColor(0,15);
         MoveTo(103,120);
         GDispStr('Files       :'+ClearNum(FNum)+'\n'+
                  'Directories :'+ClearNum(DNum));
         LF := FNum;
         LD := DNum;
      End;
      Assign(FF, DirInfo.Name);
      GetFAttr(FF, Attr);
      if not ((Attr and Directory) <> 0) and
         ((DirInfo.Name <> '000.000')and(DirInfo.Name <> '000.001')) then
      Begin
         Writeln(FilesF, DirInfo.Name);
         Inc(FNum);
      End;
      findnext(DirInfo);
   End;
   findfirst('*.*', anyfile, DirInfo);
   While DosError = 0 do
   Begin
      if (LD <> DNum) or (LF <> FNum) then
      Begin
         MoveTo(103,120);
         SetSColor(15,0);
         GDispStr('Files       :'+ClearNum(LF)+'\n'+
                  'Directories :'+ClearNum(LD));
         SetSColor(0,15);
         MoveTo(103,120);
         GDispStr('Files       :'+ClearNum(FNum)+'\n'+
                  'Directories :'+ClearNum(DNum));
         LF := FNum;
         LD := DNum;
      End;
      Assign(FF, DirInfo.Name);
      GetFAttr(FF, Attr);
      if (Attr and Directory) <> 0 then
      Begin
         Writeln(DirsF, DirInfo.Name);
         Inc(DNum);
      End;
      findnext(DirInfo);
   End;
   Close(FilesF);
   Close(DirsF);
   W.Erase;
End;

Function FType(S : String) : String;
Begin
   FType := Copy(S,3,3);
End;

Procedure InitWindow;
var
 D : String;
Begin
   E1.Pass := False;
   E2.Pass := False;
   E3.Pass := False;
   SetColor(0);
   W.Saving := True;
   W.Init(90,60,500,300,7,Blue,15,'Open File');
   W.Disp;
   SetColor(Color);
   OutTextXY(100,90,'Files:');
   OutTextXY(295,90,'Directories:');
   MoveTo(100,225);
   OutText('Drive    : ');
   D := YGetDir;
   E1.Init(D[1],8,1,GetX,GetY);
   E1.DrawBox;
   MoveTo(GetX+20,GetY);
   OutText('Find: *. ');
   E3.Init(FType(What),8,3,GetX,GetY);
   E3.DrawBox;
   SetColor(0);
   MoveTo(100,250);
   OutText('File Name: ');
   SetColor(0);
   E2.Init(D+'\',8,37,GetX,GetY);
   E2.DrawBox;
   SetColor(0);
   Ok.X := 100;
   Ok.Y := 270;
   Ok.X1 := 250;
   Ok.Y1 := 295;
   Ok.Name := '       Ok';
   Ok.PicFName := '';
   Ok.Color := 7;
   Draw_Button(Ok,7,f);

   Cancel.X := 350;
   Cancel.Y := 270;
   Cancel.X1 := 490;
   Cancel.Y1 := 295;
   Cancel.Name := '     Cancel';
   Cancel.PicFName := '';
   Cancel.Color := 7;
   Draw_Button(Cancel,7,f);
End;

Procedure InitMenus;
Begin
   MoveTo(100,100);
   SetColor(Color);
   Files.Init(160,10,Color,BColor,Yellow,'C:\000.001');
   MoveTo(295, 100);
   SetColor(Color);
   Dirs.Init(160,10,Color,BColor,Yellow,'C:\000.000');
End;
var
 SvDir : String;
 Done  : Boolean;
 LDrv  : String;
Begin
   UpCaseStr(What);
   Color := 0;
   BColor := 7;
   Assign(FilesF, 'C:\000.001');
   Assign(DirsF,'C:\000.000');
   Rewrite(FilesF);
   Rewrite(DirsF);
   Close(FilesF);
   Close(DirsF);
   InitWindow;
   InitMenus;
   SvDir := YGetDir;
   FindFiles;
   InitMenus;
   Done := False;
   Repeat
      ShowMouse;
      Repeat Until ButtonDown;
      if ChekButton(Cancel, GetMGX, GetMGY) then
       if PressButton(Cancel,7) then
       Begin
          GOpenDialog := '';
          Done := True;
       End;

      if ChekButton(W.CloseButton, GetMGX, GetMGY) then
       if TPressButton(W.CloseButton) then
       Begin
          GOpenDialog := '';
          Done := True;
       End;

      if ChekButton(Dirs.RoundBtn, GetMGX, GetMGY) then
      Repeat
         Dirs.Menu;
         if (Dirs.Ok) and (Dirs.Result <> '.') then
         Begin
            ChDir(Dirs.Result);
            FindFiles;
            E2.S := YGetDir+'\';
            E2.DrawBox;
            HideMouse;
            InitMenus;
            ShowMouse;
         End;
      Until Dirs.Ok = False;
      if ChekButton(Files.RoundBtn, GetMGX, GetMGY) then
      Repeat
         Files.Menu;
         if Files.Ok then
         Begin
            E2.S := YGetDir+'\'+Files.Result;
            E2.DrawBox;
         End;
      Until Files.Ok = False;
      if ChekButton(E1.Btn, GetMGX, GetMGY) then
       if TPressButton(E1.Btn) then
       Begin
          LDrv := E1.S;
          E1.Edit;
          UpCaseStr(E1.S);
          {$I-}ChDir(E1.S+':\');{$I+}
          if IOResult <> 0 then
          Begin
             GMessage('Drive not ready!','Error');
             E1.S := LDrv;
             E1.DrawBox;
          End
         else if E1.S <> LDrv then
          Begin
             E1.DrawBox;
             E2.S := YGetDir+'\';
             E2.DrawBox;
             FindFiles;
             InitMenus;
          End;
       End;
       if ChekButton(E2.Btn, GetMGX, GetMGY) then
        if TPressButton(E2.Btn) then
        Begin
           E2.Edit;
        End;

       if ChekButton(E3.Btn, GetMGX, GetMGY) then
        if TPressButton(E3.Btn) then
        Begin
           E3.Edit;
           UpCaseStr(E3.S);
           if E3.S <> FType(What) then
           Begin
              What := '*.'+E3.S;
              FindFiles;
              InitMenus;
           End;
           E3.DrawBox;
        End;

       if ChekButton(Ok, GetMGX, GetMGY) then
        if PressButton(Ok, 7) then
        Begin
           if not Exist(E2.S) then
             GMessage('File does not exist!','Error')
            else
             Begin
                GOpenDialog := E2.S;
                Done := True;
             End;
        End;
   Until Done;
   ChDir(SvDir);
   W.Erase;
End;

Procedure ProcPrmStr (Prms : String; var Buffer : Buf);
var
 I, Num, P : Byte;
 P1Ovr : Boolean;
Begin
   for P := 1 to 20 do
     Buffer[P] := '';
   Num := 1;
   P1Ovr := False;
   for I := 1 to Length(Prms) do
   Begin
      if (Prms[I] = ',') and (not P1Ovr) then
      Begin
         P1Ovr := True;
         Inc(Num);
      End;
      if not P1Ovr then
         Buffer[Num] := Buffer[Num] + Prms[I]
       else
        P1Ovr := False;
   End;
End;

Procedure LoadPicComm(FName : String);
Const
  Comnds : Array [1..7] of String =
          (
          '@LINE','@RECT','@CIRC','@BAR',
          '@PIX','@FILL','@TEXT'
          );
var
 F : Text;
 B : Buf;
 S : String;
 Com : Byte;
 I : Byte;
 Ok : Boolean;
Begin
   Assign(F, FName);
   Reset(F);
   While not eof(F) do
   Begin
     Readln(F,S);
     ProcPrmStr(S,B);
     UpCaseStr(B[1]);
     Ok := False;
     Com := 0;
     for I := 1 to 7 do
        if B[1] = Comnds[I] then
        Begin
           Ok := True;
           Com := I;
        End;
     if Ok then
     Begin
        if Com = 1 then
        Begin
           SetColor(Num(B[6]));
           Line(Num(B[2]),Num(B[3]),Num(B[4]),Num(B[5]));
        End;
        if Com = 2 then
        Begin
           SetColor(Num(B[6]));
           Rectangle(Num(B[2]),Num(B[3]),Num(B[4]),Num(B[5]));
        End;
        if Com = 3 then
        Begin
           SetColor(Num(B[5]));
           Circle(Num(B[2]),Num(B[3]),Num(B[4]));
        End;
        if Com = 4 then
        Begin
           SetFillStyle(1,Num(B[6]));
           Bar(Num(B[2]),Num(B[3]),Num(B[4]),Num(B[5]));
        End;
        if Com = 5 then
        Begin
           PutPixel(Num(B[2]),Num(B[3]),Num(B[4]));
        End;
        if Com = 6 then
        Begin
           SetFillStyle(1,Num(B[4]));
           FloodFill(Num(B[2]),Num(B[3]),15);
        End;
        if Com = 7 then
        Begin
           SetColor(Num(B[5]));
           OutTextXY(Num(B[2]),Num(B[3]),B[4]);
        End;
     End;
   End;
End;

Function Password_Entery(P : String) : Boolean;
var
 W  : WinGrp;
 E  : TEdit;
 PP : GPic;
 B1, B2 : Button;
 Done : Boolean;
 I    : Integer;

Procedure PutMessage(Msg : String; Color : Byte);
Begin
   HideMouse;
   SetFillStyle(1,15);
   Bar(136,161,259,184);

   SetFillStyle(1,Color);
   Bar(136,161,259,184);

   SetColor(15);
   MoveTo(140,170);
   OutText(Msg);
   SetColor(0);
   ShowMouse;
End;

Begin
   SetColor(0);
   W.Saving := True;
   W.Init(40,20,360,190,15,Blue,15,'Password protection');
   W.Disp;
   Rectangle(135,160,260,185);
   PutMessage('No Message',5);
   MoveTo(45,130);
   OutText('Password: ');
   E.Pass := True;
   E.Init('',Yellow,25,GetX,GetY);
   E.DrawBox;
   PP.Load('Lock.pic',1);
   PP.Disp(260,52,80,50);

   BTC := 0;
   With B1 do
   Begin
      X := 60;
      Y := 60;
      X1 := 150;
      Y1 := 80;
      Name := '   Ok';
      Color := 15;
      PicFName := '';
   End;
   With B2 do
   Begin
      X := 60;
      Y := 85;
      X1 := 150;
      Y1 := 105;
      Name := '  Cancel';
      Color := 15;
      PicFName := '';
   End;
   Draw_Button(B1,7,T);
   Draw_Button(B2,7,T);
   Done := False;
   Repeat
      ShowMouse;
      E.Edit;

      if E.Result = Esc then
      Begin
         Done := True;
         Password_Entery := False;
      End;

      if (E.Result = Enter) or
          (ChekButton(B1, GetMGX, GetMGY) and PressButton(B1,15)) then
      Begin
         if E.S <> P then
         Begin
            PutMessage('Access denied',LightRed);
            For I := 1 to 20 do Beep(200,20,10);
            Delay(2200);
            PutMessage('No Message',5);
            While KeyPressed do ReadKey;
            E.S := '';
            E.DrawBox;
         End
        else
         Begin
            PutMessage('Access arrived',Green);
            For I := 1 to 3 do
            Begin
               Beep(200,400,0);
               Beep(250,400,0);
               Beep(300,400,0);
            End;
            Done := True;
            Password_Entery := True;
         End;
      End;

     if ChekButton(B2, GetMGX, GetMGY) then
      if PressButton(B2,15) then
      Begin
         Done := True;
         Password_Entery := False;
      End;

    if ChekButton(W.CloseButton, GetMGX, GetMGY) then
      if TPressButton(W.CloseButton) then
      Begin
         Done := True;
         Password_Entery := False;
      End;


   Until Done;
   W.Erase;
   BTC := 15;
End;

Procedure BGIDrawChar(Num, X,Y : Integer);
var
 S : SingleChar;
 I, J : Integer;
Begin
   S := Font[Num];
   for J := 1 to 10 do
     for I := 1 to 10 do
       if S[J,I] then
         GPutPixel(I+X,J+y);
End;

Procedure GLoadFont(FntName : String);
var
 F : File;
Begin
   if Exist(FntName) then
   Begin
      Assign(F, FntName);
      Reset(F,1);
     {$I-} BlockRead(F, Font, SizeOf(TFont)); {$I+}
      if IOResult <> 0 then
      Begin
      End;
      Close(F);
   End;
End;

Procedure GOutFont(Str : String);
var
 Ch : Char;
 I  : Integer;
 Gx, Gy : Integer;
Begin
   Gx := GetX;
   Gy := GetY;
   for I := 1 to Length(Str) do
   Begin
      Ch := Str[I];
      if Ch <> ' ' then
      Begin
         BGIDrawChar(Ord(Ch)-32,Gx, Gy);
         Gx := Gx + 11;
      End
     else
      Gx := Gx + 11;
      MoveTo(Gx,Gy);
   End;
End;

Procedure SetFontSize(SizeX, SizeY : Integer);
Begin
   PixXSize := SizeX;
   PixYSize := SizeY;
End;

Procedure GOutFontLn(Str : String);
var
 Ch : Char;
 I  : Integer;
 Sx, Sy : Integer;
Begin
   Sx := GetX;
   Sy := GetY;
   for I := 1 to Length(Str) do
   Begin
      Ch := Str[I];
      if Ch <> ' ' then
      Begin
         BGIDrawChar(Ord(Ch)-32,GetX, GetY);
         MoveTo(GetX+11, GetY);
      End
     else
      MoveTo(GetX+FMaxX, GetY);
   End;
   MoveTo(Sx, Sy+FMaxY);
End;

Procedure GPutPixel(X,Y : Integer);
var
 XX, YY : Integer;
Begin
   XX := ((X-1)*PixXSize)+1;
   YY := ((Y-1)*PixYSize)+1;
   SetFillStyle(1,GetColor);
   Bar(XX,YY,XX+PixXSize-1,YY+PixYSize-1);
End;

Procedure LYpc(X,Y,X1,Y1 : Integer;C0: Boolean;File_Name:String);
var
  P:YPCHeader;
  F:File of YPCHeader;
  I,J:integer;
Begin
   if X1 > 90 then X1 := 90;
   if Y1 > 90 then Y1 := 90;
   Assign(F,File_Name);
   Reset(F);
   Read(F,P);
   if IOResult <> 0 then Exit;
   Close(F);
   for I := 1 to Y1 do for J := 1 to X1 do
   Begin
      if (not C0) and ((X+J) < MaxScrX) and ((X+J) > MinScrX) and
       ((Y+I) < MaxScrY) and ((Y+I) > MinScrY)
            then
        if P.Buff[I,J] <> 0 then PutPixel(J+X,I+Y,P.Buff[I,J]);
      if C0 then
        if P.Buff[I,J] <> 0 then PutPixel(J+X,I+Y,0);
   End;
End;

Procedure LoadFontMem(F : FPointer);
Begin
   Font := F^;
End;


Procedure DefaultYFont; external;
{$L DEFAULT.OBJ}

{------------------------------------ Init ---------------------------------}
Begin
   Register_BGI_Driver;
   Yes := 'Yes';
   No := 'No';
   Ok := 'Ok';
   GTextColor := 15;
   GBkColor := 0;
   BTC := 15;
   PixXSize := 1;
   PixYSize := 1;
End.