unit circle;

interface
uses Crt, graph, vga2, vga, mouse;

procedure DDcircle(sx,sy,color : integer);

implementation
Procedure Dcircle(x0,y0,r,color : integer);
var
 x,y : integer;
 lx1, ly1, lx2, ly2 : integer;
 tmp : real;
begin
   x := r;
   y := 0;
   lx1 := 0;
   ly1 := 0;
   ly2 := 0;
   lx2 := 0;
   repeat
      tmp := r * r - x * x;
      if tmp = 0 then
         y:= 0
       else
         y:= round(exp(system.ln(tmp)/2)*0.85);

      if  (lx1 = 0) and (ly1=0)  then
      begin
         putpixel( (x0+x) , (y0+y) ,color,vvga);
         putpixel( (x0+x) , (y0-y) ,color,vvga);
         lx1 := (x0+x);
         ly1 := (y0+y);
         lx2 := (x0+x);
         ly2 := (y0-y);
      end
     else
      begin
         line(lx1,ly1, (x0+x) , (y0+y) ,color,vvga);
         line(lx2,ly2, (x0+x) , (y0-y) ,color,vvga);
      end;

      lx1 := (x0+x);
      ly1 := (y0+y);
      lx2 := (x0+x);
      ly2 := (y0-y);

      dec(x);

   until x < -r;

end;

Procedure circle1(x0,y0,r : integer);
var
 x,y : integer;
 lx1, ly1, lx2, ly2 : integer;
 tmp : real;
begin
   x := r;
   y := 0;
   repeat
      tmp := r * r - x * x;
      if tmp = 0 then
         y:= 0
       else
         y:= round(exp(system.ln(tmp)/2)*0.85);

         putpixel( (x0+x) , (y0+y) ,15,vvga);
         putpixel( (x0+x) , (y0-y) ,15,vvga);

      dec(x);

   until x < -r;

end;


var
  svc1 : array[1..500] of byte;
  svc2 : array[1..500] of byte;

Procedure GetCircle(x0,y0,r : integer);
var
 x,y : integer;
 tmp : real;
 count : integer;
begin
   x := r;
   y := 0;
   count := 0;
   repeat
      tmp := r * r - x * x;
      if tmp = 0 then
         y:= 0
       else
         y:= round(exp(system.ln(tmp)/2)*0.85);

      begin
         inc(count);
         svc1[count] := getpixel( (x0+x) , (y0+y) ,vvga);
         svc2[count] := getpixel( (x0+x) , (y0-y) ,vvga);
      end;

      dec(x);

   until x < -r;

end;

Procedure DrawCircle(x0,y0,r : integer);
var
 x,y : integer;
 tmp : real;
 count : integer;
begin
   x := r;
   y := 0;
   count := 0;
   repeat
      tmp := r * r - x * x;
      if tmp = 0 then
         y:= 0
       else
         y:= round(exp(system.ln(tmp)/2)*0.85);

      begin
         inc(count);
         putpixel( (x0+x) , (y0+y),svc1[count] ,vvga);
         putpixel( (x0+x) , (y0-y),svc2[count] ,vvga);
      end;

      dec(x);

   until x < -r;

end;
procedure DDcircle(sx,sy, color : integer);
var
 x,y : integer;
begin
   initmouse;
   showmouse;
   repeat until buttonup;
   hidemouse;
   Repeat
       begin
          x := getmousex-160;
          y := getmousey-160;

          GetCircle(sx,sy,x);
          Circle1(sx,sy,x);
          DrawCircle(sx,sy,x);
       end;
   until buttondown;

   DCircle(sx,sy,x, Color);
   repeat until buttonup;
   showmouse;
end;

begin
end.

