{
    BSD 3-Clause License
    Copyright (c) 2021, Jerome Shidel
    All rights reserved.
}

{$IFDEF SECTINT}

    {
        nothing to see here, move along :-)
    }

{$ENDIF}

{$IFDEF SECTIMP}
var
    VideoNULL            : PVideoDriver;

procedure VideoNULL_Fatal; far;
begin
    FatalError(erGraphics_Driver_Failure,'NULL Video Driver');
    { We never return from here. Otherwise, it would require a different
      proc/func for every type of call in order not to break stuff. }
end;

procedure VideoNULL_Close; far;
begin
    { Cause shutdown process calls it. Could test if it is NULL Driver. But,
      just going to assign this proc to do nothing. }
end;

function VideoNULL_ExtendedData : pointer; far;
begin
    VideoNULL_ExtendedData := nil;
end;

procedure ConfigureBuiltInVideoNull;
var
    P : Pointer;
    I : word;
begin
    P := @VideoNULL_Fatal;
    VideoNULL := New(PVideoDriver);
    if not Assigned(VideoNULL) then begin
        FatalError(erInsufficient_memory, 'NULL Video driver')
    end;
    FillChar(VideoNull^, Sizeof(TVideoDriver), 0);
    with VideoNULL^ do begin
        { Termination marker }
        EndOfProcs.L    := $ffff;
        EndOfProcs.H    := $ffff;
        I := 0;
        while PDriverConfig(VideoNull)^.Procs[I].Segment = 0 do begin
            PDriverConfig(VideoNull)^.Procs[I].Segment := Seg(P^);
            PDriverConfig(VideoNull)^.Procs[I].Offset :=  Ofs(P^);
            Inc(I);
        end;
        Close := VideoNULL_Close;
        ExtendedData := VideoNULL_ExtendedData;
    end;
end;

{$ENDIF}