{
    BSD 3-Clause License
    Copyright (c) 2021, Jerome Shidel
    All rights reserved.
}

{$I INFERNO.DEF}
program TestEventX;

uses Inferno;

function KeyName(E : TEvent) : String;
var
    S : String;
begin
    S := '';
    case E.ScanCode of
        scEscape        : S := 'Escape';
        scTab           : S := 'Tab';
        scCaps          : S := 'CapsLock';
        scF1            : S := 'F1';
        scF2            : S := 'F2';
        scF3            : S := 'F3';
        scF4            : S := 'F4';
        scF5            : S := 'F5';
        scF6            : S := 'F6';
        scF7            : S := 'F7';
        scF8            : S := 'F8';
        scF9            : S := 'F9';
        scF10           : S := 'F10';
        scF11           : S := 'F11';
        scF12           : S := 'F12';

        scPgUp          : S := 'PgUp';
        scPgDn          : S := 'PgDn';
        scHome          : S := 'Home';
        scEnd           : S := 'End';
        scUp            : S := 'Up';
        scDown          : S := 'Down';
        scLeft          : S := 'Left';
        scRight         : S := 'Right';
        scIns           : S := 'Ins';
        scDel           : S := 'Del';
        scReturn        : S := 'Return';
        scBackspace     : S := 'Backspace';
        scNumPadEnter   : S := '(Num) Enter';
        scNumPadPlus    : S := '(Num) +';
        scNumPadMinus   : S := '(Num) -';
        scNumPadMultiply: S := '(Num) *';
        scNumPadDivide  : S := '(Num) /';
        scNumPadClear   : S := '(Num) Clr/Lock';
        scNumPadPeriod  : S := '(Num) .';
        scNumPad0       : S := '(Num) 0';
        scNumPad1       : S := '(Num) 1';
        scNumPad2       : S := '(Num) 2';
        scNumPad3       : S := '(Num) 3';
        scNumPad4       : S := '(Num) 4';
        scNumPad5       : S := '(Num) 5';
        scNumPad6       : S := '(Num) 6';
        scNumPad7       : S := '(Num) 7';
        scNumPad8       : S := '(Num) 8';
        scNumPad9       : S := '(Num) 9';

        scPrtScr        : S := 'Print Screen';
        scScrollLock    : S := 'Scroll Lock';
        scPause         : S := 'Pause';
        scLeftWin       : S := 'WIN (L)';
        scRightWin      : S := 'WIN (R)';
        scMenu          : S := 'MENU';

        scGo            : S := 'GO';
        scBack          : S := 'BACK';
        scSleep         : S := 'SLEEP';
        scFinance       : S := 'FINANCE';
        scMySites       : S := 'MY SITES';
        scCommunity     : S := 'COMMUNITY';
        scFavorites     : S := 'FAVORITES';
        scITouch        : S := 'ITOUCH';
        scEMail         : S := 'EMAIL';
        scShopping      : S := 'SHOPPING';
        scSearch        : S := 'SEARCH';
        scMyHome        : S := 'MY HOME';
        scMedia         : S := 'MEDIA';
        scMute          : S := 'MUTE';
        scVolDn         : S := 'UP (VOLUME)';
        scVolUp         : S := 'DOWN (VOLUME)';
        scPrevTrack     : S := 'PREV (TRACK)';
        scNextTrack     : S := 'NEXT (TRACK)';
        scPlayPause     : S := 'PLAY';
        scStop          : S := 'STOP';
    end;
    if S <> '' then S := ', ' + S;
    KeyName := S;
end;

var
    E : TEvent;
begin
    WriteLn('Press ESCAPE to terminate');
    repeat
        while not GetEvent(E) do;
        if KeyboardEvent(E) then begin
            case E.Kind of
                evKeyPress   : Write('  KEY PRESS: ');
                evKeyRelease : Write('KEY RELEASE: ');
            end;
            Write(
                'C:', WordHex(E.ScanCode), ' ',
                'K:', WordHex(E.KeyCode), ' ',
                'S:', WordHex(E.ShiftCode), ', ',
                WordBin(E.ShiftCode), ', ',
                WordHex(E.StatusCode), ', '
                );
            if (Lo(E.KeyCode)) >= 32 then
                Write(Chr(Lo(E.KeyCode)))
            else
                Write(' ');
            if CapsLockEnabled(E) then Write(', CAPS');
            if AnyShiftKey(E) then begin
                Write(', SHIFT (');
                if LeftShiftKey(E) then Write('L');
                if RightShiftKey(E) then Write('R');
                Write(')');
            end;
            if AnyControlKey(E) then begin
                Write(', CTRL (');
                if LeftControlKey(E) then Write('L');
                if RightControlKey(E) then Write('R');
                Write(')');
            end;
            if AnyAltKey(E) then begin
                Write(', ALT (');
                if LeftAltKey(E) then Write('L');
                if RightAltKey(E) then Write('R');
                Write(')');
            end;
            WriteLn(KeyName(E));
        end else if MouseEvent(E) then begin
            Write('MOUSE: ',
                'FLAGS ', WordHex(E.Flags), ' ',
                'BUTTONS ', WordHex(E.Buttons), ' ',
                'POS ', E.Position.X, '/', E.Position.Y, ', ',
                'MOVE ', E.Movement.X, '/', E.Movement.Y
            );
            WriteLn;
        end;
    until KeyboardEvent(E) and (E.Scancode = 1);
end.