{
    BSD 3-Clause License
    Copyright (c) 2021, Jerome Shidel
    All rights reserved.
}

{$I INFERNO.DEF}
unit FFmtASM; { Graphic Image Assembly Include File Format  }

interface

uses Inferno;

var
    ASM_Handler : PFormatHandler;

implementation

{$I-}
function ASM_Check(FileName : String) : boolean; far;
var
    F : boolean;
begin
    ClearError;
    F := False;
    ASM_Check := NoError and F;
end;

function ASM_Save(FileName : String; P : Pointer; Size : LongInt) : integer; far;
var
    T : Text;
    Base : String;
    S : String;
    X, Y : integer;
    Pal : TRGBPalettes;
    Image : PImage;
begin
    Image := P;
    Base := UCase(FileBase(FileName));
    if UCase(FileExt(FileName)) <> 'ASM' then
        FileName := Base + 'INC';
    While Pos(PathDelim, Base) > 0 do Delete(Base, 1,  Pos(PathDelim, Base));
    Base := Copy(Base, 1, Pos('.', Base) -1);
    Video^.GetPalettes(Pal);
    ClearError;
    Assign(T, FileName);
    Rewrite(T);
    if NoError then begin
        WriteLn(T, '; Nasm 2.x compatible raw graphic image include ');
        WriteLn(T, '; auto-created by Inferno Game Engine ');
        WriteLn(T, '');
        WriteLn(T, '%define IMAGE_', Base, '_BYTES  0x',
            WordHex(Video^.ImageSize(Image^.Width, Image^.Height) - 4),
             #9#9,
            '; ', Video^.ImageSize(Image^.Width, Image^.Height) - 4,
            ' bytes');
        WriteLn(T, '%define IMAGE_', Base, '_WIDTH  0x',
            WordHex(Image^.Width), #9#9, '; ',
            Image^.Width, ' pixels');
        WriteLn(T, '%define IMAGE_', Base, '_HEIGHT 0x',
            WordHex(Image^.Height), #9#9,'; ',
            Image^.Height, ' pixels');
        WriteLn(T, '');
        WriteLn(T, '%macro IMAGE_' + Base + '_DATA 0');
        for Y := 0 to Image^.Height - 1 do begin
            S := '';
            for X := 0 to Image^.Width - 1 do begin
                if S <> '' then S := S + ',';
                S := S + '0x' + ByteHex(Video^.ImageGetPixel(Image, X, Y));
                if (Length(S) > 60) and (X <> Image^.Width - 1) then begin
                    WriteLn(T, #9, 'db ', S);
                    S := '';
                end;
            end;
            if S <> '' then begin
                While Length(S) < 65 do S := S + ' ';
                WriteLn(T, #9, 'db ', S, '; ', Y);
            end;
        end;
        WriteLn(T, '%endmacro ; IMAGE_' + Base + '_DATA' );
        WriteLn(T, '');
        WriteLn(T, '%macro IMAGE_' + Base + '_RGB 0');
        WriteLn(T, '; RGB Palette Values 0-255. Most VGA takes 0-63. So, divide them by 4. Or,');
        WriteLn(T, '; simply shift them right by 2.');
        for Y := 0 to 63 do begin
            S := '';
            for X := 0 to 3 do begin
                if S <> '' then S := S + ', ';
                S := S + '0x' + ByteHex(Pal[Y * 4 + X].Red) + ',';
                S := S + '0x' + ByteHex(Pal[Y * 4 + X].Green) + ',';
                S := S + '0x' + ByteHex(Pal[Y * 4 + X].Blue);
            end;
            WriteLn(T, #9, 'db ', S, #9, '; ', Y * 4);
        end;
        WriteLn(T, '%endmacro ; IMAGE_' + Base + '_RGB');
    end;
    Close(T);
    ASM_Save := GetError;
end;

begin
    ASM_Handler := New(PFormatHandler);
    with ASM_Handler^ do begin
        Kind   := ffImage;
        UID    := 'IMGASM';
        Compat := 0;
        Exts   := 'INC;ASM';
        Check  := ASM_Check;
        Save   := ASM_Save;
        Process:= nil;
        Load   := nil;
    end;
    RegisterFileFormat(ASM_Handler);
end.