@echo off

if not exist %DOSDIR%\LINKS\QRESFILE.BAT goto NoQRES

set BUILD_SELF=%0
if "%1" == "clean" goto CLEAN
if not "%1" == "upx" goto NoUPX
set MAIN_UPX=yes
shift
:NoUPX
if "%MAIN_SOURCE%" == "" set MAIN_SOURCE=LIBRARY

if "%1" == "dev" deltree /y FAILED >NUL
if "%1" == "" deltree /y FAILED >NUL
if exist FAILED goto ErrorDone

if errorlevel 1 goto ZeroErrorLevel
verrlvl 0
if errorlevel 1 goto MissingV8PT
:ZeroErrorLevel
verrlvl 1
if not errorlevel 1 goto MissingV8PT
verrlvl 0

:Repeat
set ASM=NASM.EXE
set TPC=TPC.EXE
set QRES=CALL QRESFILE.BAT
if exist %DOSDIR%\LINKS\NASM.BAT set ASM=call NASM.BAT
if exist %DOSDIR%\LINKS\NASM.COM set ASM=NASM.COM
if exist %DOSDIR%\LINKS\TPC.BAT set TPC=call TPC.BAT
if exist %DOSDIR%\LINKS\TPC.COM set TPC=TPC.COM

if "%1" == "dev" goto BUILD-DEV
if "%1" == "" goto BUILD-ALL
goto %1

:NASM-COM
shift
vecho compile /fCyan %1.ASM /fGray
if exist %1.COM del %1.COM
%ASM% %1.ASM -fbin -O9 -o %1.COM
if errorlevel 1 goto Error
if not exist BIN\%1.COM goto Error
vecho created binary executable /fLightYellow %1.COM /fGray
goto End

:NASM-OBJ
shift
if exist %1.OBJ goto End
vecho compile /fCyan %1.ASM /fGray
%ASM% %1.ASM -fobj -O9 -o %1.OBJ
if errorlevel 1 goto Error
if not exist %1.OBJ goto Error
vecho created binary obj /fLightCyan %1.OBJ /fGray
goto End

:NASM-SUB
if "%2" == "" goto Error
set PROG=
vfdutil /n %2 | set /p PROG=
if "%PROG%" == "" goto End
call %BUILD_SELF% NASM-OBJ %PROG%
goto End

:TPC-TPU
shift
if exist %1.TPU goto End
if "%1" == "TESTEVNT" goto End
if "%1" == "TESTDRVR" goto End
if "%1" == "TESTVID" goto End
if "%1" == "TESTBNCH" goto End
if "%1" == "TESTDEV" goto End
if "%1" == "TESTVRT" goto End
vecho compile /fCyan %1.PAS /fGray
%TPC% -M %1.PAS
if errorlevel 1 goto Error
if exist %1.TPU goto TPC-TPUOK
if exist %1.EXE goto TPC-EXEOK
goto Error
:TPC-TPUOK
vecho created pascal unit /fLightGreen %1.TPU /fGray
goto End
:TPC-EXEOK
vecho created executable /fWhite %1.EXE /fGray
goto End

:TPC-SUB
if "%2" == "" goto Error
set PROG=
vfdutil /n %2 | set /p PROG=
if "%PROG%" == "%MAIN_SOURCE%" goto End
call %BUILD_SELF% TPC-TPU %PROG%
goto End

:DIR-EXE
dir %2 | vstr /b/l2
goto End

:ADD-RES
if "%2" == "" goto end
set PROG=
vfdutil /n %2 | set /p PROG=
if "%PROG%" == "" goto ADD-RES
if "%PROG%" == "TESTASET" goto TestAsset
if not exist %PROG%\NUL goto end
vecho attach /fCyan %PROG% /fGrey core resource assets
cd drivers
%QRES% /a /m /f ..\%PROG%.EXE /i *.drv
cd ..\core
%QRES% /a /m /f ..\%PROG%.EXE /i *.*
cd ..\%PROG%
%QRES% /a /m /f ..\%PROG%.EXE /i *.*
cd ..
if "%PROG%" == "BLOGAM" goto BlogamFonts
if "%PROG%" == "IMGEDIT" goto ImgEditFonts
rem goto End
:BlogamFonts
cd fonts
%QRES% /a /m /f ..\%PROG%.EXE /i 10*.fnt
cd ..
goto End
:ImgEditFonts
cd fonts
%QRES% /a /m /f ..\%PROG%.EXE /i *.*
cd ..
goto End

:TestAsset
vecho attach /fCyan %PROG% /fGrey core resource assets
cd drivers
%QRES% /a /m /f ..\%PROG%.EXE /i *.drv
cd ..\core
%QRES% /a /m /f ..\%PROG%.EXE /i *.*
cd ..\fonts
%QRES% /a /m /f ..\%PROG%.EXE /i *.*
cd ..
goto End

goto end

:BUILD-DEV
deltree /y *.EXE >NUL
deltree /y *.COM >NUL
deltree /y *.TPU >NUL
deltree /y *.DAT >NUL
deltree /y *.LOG >NUL
:BUILD-ALL
if not "%1" == "dev" call %BUILD_SELF% clean

if exist DRIVERS\VGA386.DRV goto SkipDrivers
if not exist DRIVERS\VGA386.ASM goto SkipDrivers
cd DRIVERS
call BUILD.BAT
cd ..
:SkipDrivers

veach /d *.asm /x %BUILD_SELF% NASM-SUB *
if errorlevel 1 goto Error
if exist FAILED goto ErrorDone
veach /d *.pas /x %BUILD_SELF% TPC-SUB *
if errorlevel 1 goto Error
if exist FAILED goto ErrorDone

if not exist %MAIN_SOURCE%.PAS goto NoMain
call %BUILD_SELF% TPC-TPU %MAIN_SOURCE%
if not exist %MAIN_SOURCE%.EXE goto Error
if exist FAILED goto ErrorDone
:NoMain

veach /d *.exe /x %BUILD_SELF% ADD-RES *

if not "%MAIN_UPX%" == "yes" goto SkipUPX
upx --8086 *.EXE
:SkipUPX
vecho /p Units...
veach /d *.TPU /x %BUILD_SELF% DIR-EXE *
if not exist %MAIN_SOURCE%.PAS goto NoBins
vecho /p Binaries...
veach /d *.COM /d *.EXE /d *.DAT /x %BUILD_SELF% DIR-EXE *
vecho
:NoBins
set MAIN_UPX=
set BUILD_SELF=
goto Done

:MissingV8PT
echo Missing required V8Power Tools for DOS.
echo visit http://up.lod.bz/V8Power
goto End

:NoQRES
echo Cannot build! Missing %DOSDIR%\LINKS\QRESFILE.BAT. This file is required and
echo must execute QRESFILE.EXE %%1 %%2 %%3 %%4 %%5 %%6 %%7 %%8 %%9
echo QRESFILE is a executable resource managment utility provided with PGME.
echo see http://up.lod.bz/PGME
goto end

:CLEAN
deltree /y FAILED >NUL
deltree /y BIN >NUL
deltree /y *.LOG >NUL
deltree /y *.EXE >NUL
deltree /y *.COM >NUL
deltree /y *.OBJ >NUL
deltree /y *.TPU >NUL
deltree /y *.DAT >NUL
deltree /y DRIVERS\*.DRV >NUL
goto End

:Error
vecho /fLightRed ERROR! /fGray %1
echo Build Failed>FAILED

:ErrorDone
verrlvl 1
set MAIN_UPX=
set BUILD_SELF=

:Done
set ASM=
set TPC=
set QRES=
set SOURCES=
set PROG=
set MAIN_SOURCE=

:End
