/* This is part of the NEWTRACK eyetracking software, (c) 2004 by  */
/* Eric Auer. NEWTRACK is free software; you can redistribute it   */
/* and modify it under the terms of the GNU General Public License */
/* as published by the Free Software Foundation; either version 2  */
/* of the License, or (at your option) any later version.          */
/*     NEWTRACK is distributed in the hope that it will be useful, */
/*     but WITHOUT ANY WARRANTY; without even the implied warranty */
/*     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.     */
/*     See the GNU General Public License for more details.        */
/* You should have received a copy of the GNU General Public       */
/* License (license.txt) along with this program; if not, check    */
/* www.gnu.org or write to the Free Software Foundation, Inc., 59  */
/* Temple Place, Suite 330, Boston, MA  02111-1307 USA.            */

/* data structures for BIOS functions for VESA graphics mode access */

#ifndef VESADATA_H
#define VESADATA_H 1

#include "arch.h"	/* sint8 uint8 ... 32 */


#pragma pack(1)		/* no alignment, just byte by byte */
typedef struct crtcParams { /* for VESA VBE 3.0 refresh rate control */
  uint16 htotal, hsync1, hsync2, vtotal, vsync1, vsync2;
  uint8 crtcflags;	/* bit 0 doublescan, 1 interlace, 2 ~vsync 3 ~hsync */
  uint32 clock;
  uint16 vrefresh;	/* should be 100*clock / (htotal*vtotal) */
  uint8 rsvd[40];
} CRTC_PARAMS;		/* text mode hint: vrefresh must be max 7200, lie. */

typedef struct vesaCard {
  char magic[4];	/* 00 on call: VBE2 on return: VESA */
  			/* could use uint8 here for 16bit char arch */
  uint16 version;	/* 04 */
  uint32 oemnamePTR;	/* 06 far DOS pointer. Can be inside this buffer */
  uint32 capabilities;	/* 0a - 1 8bitdac 2 nonvga 4 blankbit */
  uint32 modelistPTR;	/* 0e list of mode words, -1 terminated */
  uint16 memsize;	/* 12 unit is 64k */
  uint16 oemversion;	/* 14 */
  uint32 vendornamePTR, productnamePTR, revisionnamePTR;
  			/* 16, 1a, 1e */
  /* whole buffer is 512 bytes for VBE 2, so alloc enough space! */
  /* e.g. the modelist and the strings can be in the buffer... */
} VESA_CARD;

typedef struct vesaMode {
  uint16 modeflags;	/* 00 - 1 "1" 2 extrainfo 4 BIOSsupported */
  			/* 8 color 16 gfx - and only VBE 2.0+: */
  			/* 32 nonvga 64 nonbanked 128 LFBable */
  uint8 windowA, windowB;		/* 02, 03 */
  uint16 windowGran, windowSize;	/* 04, 06 - in kbytes */
  uint16 windowAseg, windowBseg;	/* 08, 0a - DOS segment */
  uint32 bankFuncPTR;	/* 0c far DOS pointer to bank switcher */
  uint16 bytes_line;	/* 10 */
  uint16 width, height;	/* 12, 14 - in pixels or chars */
  uint8  charwidth, charheight;	/* 16, 17 - (recommended) char size */
  uint8  planes, bits_pixel, banks, memorymode, banksize, pages, dummy;
  			/* 18 ... 1e, memory modes can be: */
  			/* 0 text 1 CGA 2 HGC 3 EGAplanes 4 MCGA */
  			/* 5 modeX 6 high/truecolorRGB 7 highcolorYUV */
  uint8  redBits, redShift, greenBits, greenShift, blueBits, blueShift;
  uint8  extraBits, extraShift;		/* 1f ... 26, VBE 1.2+ */
  uint8  colorflags;	/* 27 - 1 progr. color ramp 2 extra is free */
  			/* LFB is only available for VESA VBE 2.0+ */
  uint32 lfbPTR;	/* 28 linear 32 bit address of frame buffer */
  uint32 offscreenPTR;	/* 2c linear address of offscreen memory */
  uint16 offscreensize;	/* 30 size of offscreen memory in kbytes */
  			/* the following is only available for VESA VBE 3.0+ */
  uint16 lfb_bytes_line;
  uint8 maxpagebanked, maxpagelfb;
  uint8 lfbRmask, lfbRshift, lfbGmask, lfbGshift, lfbBmask, lfbBshift;
  uint8 lfbAmask, lfbAshift;	/* no color but either alpha or user defined */
  uint32 maxclock;	/* Maximum pixel clock in Hertz */
  /* buffer should be 256 bytes big for this */
} VESA_MODE;
#pragma pack()
/* or use __attribute__ ((packed)) before the ; for every element... */

#endif
