## V8Power Tools Turbo Booster

BSD 3-Clause License
Copyright (c) 2018-2022, Jerome Shidel
All rights reserved.

## Version

project development reboot pre-release
(there is more to do, than is already done)

## Editions

There are three different builds of V8Turbo from the same source code.

* V8Turbo - The primary feature rich edition.
* V8Micro - The economy edition.
* V8TurboX - A feature rich accessibility focused edition.

Of the three editions, *V8Micro* is the most like other traditional DOS command
line interpreters. It has most (but not all) of the V8Turbo specific commands.
It has no mouse or direct video support. Only supports a single theme and
provides no means to change video modes. Nor, does it provide any internal
command help.

V8TurboX is similar to *V8Turbo*. However, it contains some additional
functionality specifically and default settings for accessibility users.
This edition will most likely change drastically based on feedback from the
users of this edition.

## Requirements

[FreeDOS](http://freedos.org/), [DOSBox](https://www.dosbox.com/) or
other DOS based operating system.

## Minimum Build Requirements

[NASM](https://nasm.us/) 2.15.05 or later required
[UPX](https://upx.github.io/) 3.96 or later recommended

[DosKit LIBS](https://gitlab.com/DOSx86/DosKit/-/tree/master/DEVEL/DOSKIT/LIBS)
(At some point, will be included directly for easy building from source)

## How is V8Turbo Different from other Command Line Shells?

* It is not (normally) a single flat color. It uses color in different
intensities to help draw attention and focus to the most relevant information.
* Integrated mouse support which can be used to select options, navigate the
filesystem, etc. Sometimes even for past commands that are no longer actively
running. (V8Turbo only)
* Additional features and commands.
* Ability to change languages without a requiring a restart, reboot or changing
shell binaries.

## New commands

* COMMANDS - list available commands with a short description.
* ERRORLEVEL - to report the current ERRORLEVEL code and message. Or, to change
the current ERRORLEVEL.
* GOSUB - TBA
* LANG - TBA
* MIME - TBA
* POWERNAP - TBA
* RETURN - TBA
* TEXTMODE - to report, probe or change the current text mode. (V8Turbo/X only)
* THEME - to select or change the current color theme. (V8Turbo/X only)

There are more to come. But, this list is the initial "known to be coming" (or
has already been implemented) additional commands provided by V8Turbo.

## Old commands with new features.

* BEEP - can vary play multiple tones with different frequencies and durations.
* CDD - option to list directory after changing drive and/or directories.
* DOSKEY - TBA
* ERASE - not identical to DELETE. It renames, overwrites then deletes files.
* EXIT - Can be used to terminate a batch or the shell. Also, can set ERRORLEVEL.
* HISTORY - TBA
* MKDIR - TBA
* PATH - Prints the path as a list when viewing.
* PAUSE - TBA
* POPD - TBA
* PUSHD - TBA
* SET - TBA
* TYPE - TBA
* VOL - Can display volume names for multiple drives.

Like the new command list. This is just what has additional functionality (or
will have in the near future).
